/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.drippedout.datagen;

import com.mrbysco.drippedout.registry.DripRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class DrippedDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new DripLoots(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new Language(packOutput));
        generator.addProvider(true, (DataProvider)new Models(packOutput));
    }

    private static class DripLoots
    extends LootTableProvider {
        public DripLoots(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(DrilBlockLoot::new, LootContextParamSets.BLOCK)), completableFuture);
        }

        protected void validate(WritableRegistry<LootTable> writableregistry, @NotNull ValidationContext validationcontext, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ProblemReporter.Collector problemreporter$collector) {
            writableregistry.forEach(lootTable -> lootTable.validate(validationcontext));
        }

        public static class DrilBlockLoot
        extends BlockLootSubProvider {
            protected DrilBlockLoot(HolderLookup.Provider lookupProvider) {
                super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
            }

            protected void generate() {
                this.dropOther((Block)DripRegistry.SIDEWAYS_POINTED_DRIPSTONE.get(), (ItemLike)Items.POINTED_DRIPSTONE);
            }

            @NotNull
            protected Iterable<Block> getKnownBlocks() {
                return DripRegistry.BLOCKS.getEntries().stream().map(block -> (Block)block.get())::iterator;
            }
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "drippedout", "en_us");
        }

        protected void addTranslations() {
            this.addBlock((Supplier)DripRegistry.SIDEWAYS_POINTED_DRIPSTONE, "Sideways Pointed Dripstone");
        }
    }

    private static class Models
    extends ModelProvider {
        private static final ModelTemplate POINTED_DRIPSTONE = ModelTemplates.create((String)"drippedout:sideways_pointed", (TextureSlot[])new TextureSlot[]{TextureSlot.CROSS});

        public Models(PackOutput packOutput) {
            super(packOutput, "drippedout");
        }

        protected void registerModels(BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
            TextureMapping texturemapping = TextureMapping.cross((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block/pointed_dripstone_up_tip"));
            ResourceLocation resourcelocation = POINTED_DRIPSTONE.extend().renderType("cutout").build().create((Block)DripRegistry.SIDEWAYS_POINTED_DRIPSTONE.get(), texturemapping, blockModels.modelOutput);
            blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)DripRegistry.SIDEWAYS_POINTED_DRIPSTONE.get()), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)resourcelocation)).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
        }
    }
}

