/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.drippedout.handler;

import com.mrbysco.drippedout.registry.DripRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class PlacementHandler {
    @SubscribeEvent
    public void onBlockPlacement(PlayerInteractEvent.RightClickBlock placeEvent) {
        Block sidewaysBlock;
        BlockState state;
        if (placeEvent.getFace() == null) {
            return;
        }
        Level level = placeEvent.getLevel();
        Player player = placeEvent.getEntity();
        BlockPos relativePos = placeEvent.getPos().relative(placeEvent.getFace());
        ItemStack stack = placeEvent.getItemStack();
        if (stack.is(Items.POINTED_DRIPSTONE) && Direction.Plane.HORIZONTAL.test(placeEvent.getFace()) && (state = (sidewaysBlock = (Block)DripRegistry.SIDEWAYS_POINTED_DRIPSTONE.get()).getStateForPlacement(new BlockPlaceContext(player, placeEvent.getHand(), new ItemStack((ItemLike)sidewaysBlock), placeEvent.getHitVec()))) != null && state.canSurvive((LevelReader)level, relativePos) && level.setBlockAndUpdate(relativePos, state)) {
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, relativePos);
            SoundType soundtype = state.getSoundType((LevelReader)level, relativePos, (Entity)player);
            level.playSound((Entity)player, relativePos, state.getSoundType((LevelReader)level, relativePos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            placeEvent.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            placeEvent.setCanceled(true);
        }
    }
}

