/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.worldless;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.OptionalLong;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.libreh.worldless.command.Commands;
import me.libreh.worldless.config.Config;
import me.libreh.worldless.mixin.LevelPropertiesAccessor;
import me.libreh.worldless.world.ServerTaskExecutor;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6673;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worldless
implements ModInitializer {
    public static final String MOD_ID = "worldvanisher";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"worldvanisher");
    public static MinecraftServer SERVER;
    public static boolean shouldCancelSaving;
    public static boolean startTimer;
    public static int tickCount;
    public static int worldTimer;
    public static int resetTimer;
    public static ServerTaskExecutor taskExecutor;

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, access, environment) -> Commands.worldlessCommand((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            SERVER = server;
            Config.loadConfig();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> Worldless.unzipLobbyWorld());
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            if (startTimer && ++tickCount == 19) {
                if ((worldTimer -= 20) <= 0) {
                    startTimer = false;
                    Worldless.resetWorlds(class_6673.method_39001());
                } else {
                    int minutes = (int)Math.floor((double)worldTimer % 72000.0 / 1200.0);
                    Object minutesString = minutes <= 9 ? "0" + minutes : String.valueOf(minutes);
                    int seconds = (int)Math.floor((double)worldTimer % 1200.0 / 20.0);
                    Object secondsString = seconds <= 9 ? "0" + seconds : String.valueOf(seconds);
                    class_124 formatting = class_124.field_1080;
                    if (minutes == 0) {
                        formatting = seconds > 10 ? class_124.field_1061 : class_124.field_1079;
                    }
                    for (class_3222 player : SERVER.method_3760().method_14571()) {
                        player.method_7353((class_2561)class_2561.method_43470((String)((String)minutesString + ":" + (String)secondsString)).method_27692(formatting), true);
                        if (!Config.getConfig().countdownSounds || minutes != 0 || seconds > 10) continue;
                        float pitch = switch (seconds) {
                            case 5, 6, 7, 8, 9, 10 -> 1.03f;
                            case 4 -> 1.2f;
                            case 3 -> 1.4f;
                            case 2 -> 1.6f;
                            case 1 -> 1.8f;
                            default -> 2.0f;
                        };
                        player.method_17356((class_3414)class_3417.field_14622.comp_349(), class_3419.field_15247, 1.0f, pitch);
                    }
                }
                tickCount = 0;
            }
        });
    }

    private static void tickKeepAlive(MinecraftServer server) {
        if (server.method_3787() != null) {
            server.method_3787().method_14357();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetWorlds(long seed) {
        Worldless.tickKeepAlive(SERVER);
        Worldless.SERVER.field_35437 = true;
        try {
            SERVER.method_3760().method_14617();
            for (class_3218 world : SERVER.method_3738()) {
                world.method_17983().method_125();
            }
            Worldless.tickKeepAlive(SERVER);
            SERVER.method_18855();
            shouldCancelSaving = true;
            for (class_3218 world : SERVER.method_3738()) {
                String[] directories;
                world.close();
                Worldless.tickKeepAlive(SERVER);
                for (String dir : directories = new String[]{"region", "poi", "entities"}) {
                    File file = Worldless.SERVER.field_23784.method_27424(world.method_27983()).resolve(dir).toFile();
                    if (!file.exists()) continue;
                    Worldless.deleteRecursively(file);
                }
                Worldless.tickKeepAlive(SERVER);
            }
            LevelPropertiesAccessor levelPropertiesAccessor = (LevelPropertiesAccessor)SERVER.method_27728();
            levelPropertiesAccessor.setGeneratorOptions(levelPropertiesAccessor.getGeneratorOptions().method_28024(OptionalLong.of(seed)));
            SERVER.method_3735();
            Worldless.tickKeepAlive(SERVER);
        }
        catch (IOException e) {
            LOGGER.info("Failed to reset", (Throwable)e);
        }
        finally {
            Worldless.SERVER.field_35437 = false;
            shouldCancelSaving = false;
        }
        Worldless.unzipLobbyWorld();
        for (class_3222 player : SERVER.method_3760().method_14571()) {
            Worldless.updatePlayer(player);
        }
        worldTimer = resetTimer;
        startTimer = true;
    }

    public static void updatePlayer(class_3222 player) {
        if (!player.method_5805()) {
            class_3222 newPlayer = player;
            class_3244 networkHandler = newPlayer.field_13987;
            networkHandler.method_12068(new class_2799(class_2799.class_2800.field_12774));
            newPlayer = networkHandler.field_14140;
            if (taskExecutor == null) {
                taskExecutor = new ServerTaskExecutor(SERVER);
            }
            class_3222 finalNewPlayer = newPlayer;
            taskExecutor.execute(() -> Worldless.updatePlayer(finalNewPlayer));
            return;
        }
        player.method_48105(SERVER.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"worldless", (String)"lobby"))), 0.0, 1024.0, 0.0, Set.of(), 0.0f, 0.0f, true);
        class_243 spawnPos = player.method_14245(SERVER.method_30002(), SERVER.method_30002().method_43126()).method_61082();
        player.method_48105(SERVER.method_30002(), spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), Set.of(), 0.0f, 0.0f, false);
    }

    public static void unzipLobbyWorld() {
        try (ZipInputStream zis = new ZipInputStream(class_1937.class.getResourceAsStream("/worldless/lobby_world.zip"));){
            ZipEntry entry;
            byte[] buffer = new byte[1024];
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = new File(String.valueOf(FabricLoader.getInstance().getGameDir().resolve("world")) + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                    continue;
                }
                new File(newFile.getParent()).mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int length;
                    while ((length = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, length);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.info("Failed to unzip world", (Throwable)e);
        }
    }

    private static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                Worldless.deleteRecursively(subFile);
            }
        }
        file.delete();
    }
}

