/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.worldless.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import me.libreh.worldless.Worldless;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Config CONFIG;
    public boolean countdownSounds = true;
    public boolean endTimerOnDragonDeath = true;

    public static Config getConfig() {
        return CONFIG;
    }

    public static void loadConfig() {
        Config oldConfig = CONFIG;
        CONFIG = null;
        try {
            File configFile = Config.getConfigFile();
            CONFIG = configFile.exists() ? (Config)GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8), Config.class) : new Config();
            Config.saveConfig();
        }
        catch (IOException exception) {
            CONFIG = oldConfig;
        }
    }

    public static void saveConfig() {
        try {
            File configFile = Config.getConfigFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
            writer.write(GSON.toJson((Object)CONFIG));
            writer.close();
        }
        catch (Exception exception) {
            Worldless.LOGGER.error("Something went wrong while saving config!", (Throwable)exception);
        }
    }

    private static File getConfigFile() {
        return new File(FabricLoader.getInstance().getConfigDir().toFile(), "worldvanisher.json");
    }
}

