/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.worldless;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.libreh.worldless.command.Commands;
import me.libreh.worldless.config.ConfigManager;
import me.libreh.worldless.mixin.LevelPropertiesAccessor;
import me.libreh.worldless.world.ServerTaskExecutor;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6673;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Worldless
implements ModInitializer {
    public static final String MOD_ID = "worldless";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"worldless");
    public static final class_2960 LOBBY_WORLD_ID = class_2960.method_60655((String)"worldless", (String)"lobby");
    public static final String LOBBY_WORLD_ZIP_PATH = "/worldless/lobby_world.zip";
    public static final int TICKS_PER_SECOND = 20;
    public static final int COUNTDOWN_SOUND_THRESHOLD = 10;
    private static final String[] WORLD_DATA_DIRECTORIES = new String[]{"region", "poi", "entities"};
    private static final int COUNTDOWN_SOUND_BASE_PITCH = 2;
    private static final float COUNTDOWN_SOUND_PITCH_DECREMENT = 0.2f;
    public static MinecraftServer server;
    public static boolean shouldCancelSaving;
    public static boolean isCountdownRunning;
    public static int tickCounter;
    public static int worldTimer;
    public static int resetTimer;
    public static ServerTaskExecutor taskExecutor;
    public static final Set<UUID> fountainPlayers;

    public void onInitialize() {
        this.registerCommands();
        this.registerServerLifecycleEvents();
        this.registerTickHandler();
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, access, environment) -> Commands.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    private void registerServerLifecycleEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Worldless.server = server;
            ConfigManager.loadConfig();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            taskExecutor = new ServerTaskExecutor(server);
            Worldless.unzipLobbyWorld();
        });
    }

    private void registerTickHandler() {
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            if (!isCountdownRunning) {
                return;
            }
            if (++tickCounter < 19) {
                return;
            }
            tickCounter = 0;
            if ((worldTimer -= 20) <= 0) {
                isCountdownRunning = false;
                Worldless.resetWorlds(server, class_6673.method_39001());
                return;
            }
            this.updateTimerDisplay(server);
        });
    }

    private void updateTimerDisplay(MinecraftServer server) {
        int totalSeconds = worldTimer / 20;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        String timeString = String.format("%02d:%02d", minutes, seconds);
        class_124 formatting = this.getTimeFormatting(minutes, seconds);
        class_5250 timerText = class_2561.method_43470((String)timeString).method_27692(formatting);
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353((class_2561)timerText, true);
        }
        this.playCountdownSounds(server.method_3760().method_14571(), minutes, seconds);
    }

    private class_124 getTimeFormatting(int minutes, int seconds) {
        return minutes > 0 ? class_124.field_1080 : (seconds > 10 ? class_124.field_1061 : class_124.field_1079);
    }

    private void playCountdownSounds(List<class_3222> players, int minutes, int seconds) {
        if (!ConfigManager.getConfig().countdownSounds || minutes != 0 || seconds > 10) {
            return;
        }
        float pitch = 2.0f - (float)seconds * 0.2f;
        for (class_3222 player : players) {
            player.method_17356((class_3414)class_3417.field_14622.comp_349(), class_3419.field_15247, 1.0f, pitch);
        }
    }

    public static void resetWorlds(MinecraftServer server, long seed) {
        Worldless.performWithKeepAlive(() -> {
            server.field_35437 = true;
            try {
                Worldless.saveWorldData(server);
                Worldless.deleteWorldFiles(server);
                Worldless.regenerateWorld(server, seed);
            }
            catch (IOException e) {
                LOGGER.error("Failed to reset worlds", (Throwable)e);
            }
            finally {
                server.field_35437 = false;
                shouldCancelSaving = false;
            }
            Worldless.postResetActions(server);
        });
    }

    private static void performWithKeepAlive(Runnable action) {
        if (server.method_3787() != null) {
            server.method_3787().method_14357();
        }
        action.run();
    }

    private static void saveWorldData(MinecraftServer server) throws IOException {
        server.method_3760().method_14617();
        for (class_3218 world : server.method_3738()) {
            world.method_17983().method_125();
            Worldless.performWithKeepAlive(() -> {});
        }
    }

    private static void deleteWorldFiles(MinecraftServer server) throws IOException {
        for (class_3218 world : server.method_3738()) {
            world.close();
            Worldless.performWithKeepAlive(() -> {});
            Path worldDir = server.field_23784.method_27424(world.method_27983());
            for (String dir : WORLD_DATA_DIRECTORIES) {
                File file = worldDir.resolve(dir).toFile();
                if (!file.exists()) continue;
                Worldless.deleteRecursively(file);
            }
            Worldless.performWithKeepAlive(() -> {});
        }
    }

    private static void regenerateWorld(MinecraftServer server, long seed) {
        LevelPropertiesAccessor accessor = (LevelPropertiesAccessor)server.method_27728();
        accessor.setGeneratorOptions(accessor.getGeneratorOptions().method_28024(OptionalLong.of(seed)));
        server.method_3735();
        Worldless.performWithKeepAlive(() -> {});
    }

    private static void postResetActions(MinecraftServer server) {
        Worldless.unzipLobbyWorld();
        fountainPlayers.clear();
        for (class_3222 serverPlayer : server.method_3760().method_14571()) {
            Worldless.updatePlayer(serverPlayer);
        }
        worldTimer = resetTimer;
        isCountdownRunning = true;
    }

    public static void updatePlayer(class_3222 player) {
        if (player.method_5805()) {
            Worldless.teleportToLobby(player);
        } else {
            Worldless.respawnPlayer(player);
        }
    }

    private static void teleportToLobby(class_3222 player) {
        class_3218 lobbyWorld = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)LOBBY_WORLD_ID));
        if (lobbyWorld == null) {
            LOGGER.warn("Lobby world not found, teleporting to overworld spawn");
            Worldless.teleportToOverworldSpawn(player);
            return;
        }
        player.method_48105(lobbyWorld, 0.0, 1024.0, 0.0, Set.of(), 0.0f, 0.0f, true);
        Worldless.teleportToOverworldSpawn(player);
    }

    private static void teleportToOverworldSpawn(class_3222 player) {
        class_243 spawnPos = player.method_14245(server.method_30002(), server.method_30002().method_43126()).method_61082();
        player.method_48105(server.method_30002(), spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), Set.of(), 0.0f, 0.0f, false);
    }

    private static void respawnPlayer(class_3222 player) {
        player.field_13987.method_12068(new class_2799(class_2799.class_2800.field_12774));
        taskExecutor.execute(() -> Worldless.updatePlayer(player.field_13987.field_14140));
    }

    public static void unzipLobbyWorld() {
        try (ZipInputStream zis = new ZipInputStream(class_1937.class.getResourceAsStream(LOBBY_WORLD_ZIP_PATH));){
            ZipEntry entry;
            byte[] buffer = new byte[1024];
            while ((entry = zis.getNextEntry()) != null) {
                File targetFile = FabricLoader.getInstance().getGameDir().resolve("world").resolve(entry.getName()).toFile();
                if (entry.isDirectory()) {
                    targetFile.mkdirs();
                    continue;
                }
                Worldless.ensureParentDirectoryExists(targetFile);
                Worldless.writeZipEntryToFile(zis, buffer, targetFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to unzip lobby world", (Throwable)e);
        }
    }

    private static void ensureParentDirectoryExists(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    private static void writeZipEntryToFile(ZipInputStream zis, byte[] buffer, File targetFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            int length;
            while ((length = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, length);
            }
        }
    }

    private static void deleteRecursively(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                Worldless.deleteRecursively(child);
            }
        }
        if (!file.delete()) {
            LOGGER.warn("Failed to delete file: {}", (Object)file.getAbsolutePath());
        }
    }

    static {
        fountainPlayers = new HashSet<UUID>();
    }
}

