/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.worldless.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import me.libreh.worldless.Worldless;
import me.libreh.worldless.config.ConfigManager;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Commands {
    private static final String MAIN_PERMISSION = "worldless.main";
    private static final String RELOAD_PERMISSION = "worldless.reload";
    private static final class_2561 RELOAD_SUCCESS = class_2561.method_43470((String)"Reloaded config!");
    private static final class_2561 RELOAD_ERROR = class_2561.method_43470((String)"Error occurred while reloading config!").method_27692(class_124.field_1061);

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"worldless").then(Commands.createReloadCommand())).then(Commands.createTimerCommand())).then(Commands.createStopCommand()));
    }

    private static LiteralArgumentBuilder<class_2168> createReloadCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Commands::hasReloadPermission)).executes(context -> {
            boolean success = ConfigManager.loadConfig();
            ((class_2168)context.getSource()).method_9226(() -> success ? RELOAD_SUCCESS : RELOAD_ERROR, false);
            return 1;
        });
    }

    private static RequiredArgumentBuilder<class_2168, Integer> createTimerCommand() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"timer", (ArgumentType)IntegerArgumentType.integer()).requires(Commands::hasMainPermission)).executes(context -> {
            int timer = IntegerArgumentType.getInteger((CommandContext)context, (String)"timer");
            if (timer == 0) {
                Worldless.isCountdownRunning = false;
            } else {
                Worldless.worldTimer = Worldless.resetTimer = timer * 20 + 39;
                Worldless.isCountdownRunning = true;
            }
            return 1;
        });
    }

    private static LiteralArgumentBuilder<class_2168> createStopCommand() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"stop").executes(context -> {
            Worldless.isCountdownRunning = false;
            return 1;
        });
    }

    private static boolean hasReloadPermission(class_2168 source) {
        return !source.method_43737() || Commands.hasPermission(source.method_44023(), RELOAD_PERMISSION);
    }

    private static boolean hasMainPermission(class_2168 source) {
        return !source.method_43737() || Commands.hasPermission(source.method_44023(), MAIN_PERMISSION);
    }

    private static boolean hasPermission(class_3222 player, String permission) {
        return Permissions.check((class_1297)player, (String)permission) || player.method_64475(4);
    }
}

