/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.worldless.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.libreh.worldless.Worldless;
import me.libreh.worldless.config.Config;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    public static int VERSION = 1;
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("worldless.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Config CONFIG;

    public static Config getConfig() {
        if (CONFIG == null) {
            return Config.DEFAULT;
        }
        return CONFIG;
    }

    public static boolean loadConfig() {
        boolean ENABLED;
        try {
            Config config = Files.exists(CONFIG_PATH, new LinkOption[0]) ? (Config)GSON.fromJson(Files.readString(CONFIG_PATH), Config.class) : new Config();
            config.version = VERSION;
            ConfigManager.overrideConfig(config);
            CONFIG = config;
            ENABLED = true;
        }
        catch (Throwable exception) {
            ENABLED = false;
            Worldless.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return ENABLED;
    }

    public static void overrideConfig(Config config) {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
            CONFIG = config;
        }
        catch (Exception e) {
            Worldless.LOGGER.error("Something went wrong while saving config!");
            e.printStackTrace();
        }
    }
}

