/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.classic.model.processor;

import host.plas.bou.libs.logback.classic.model.ReceiverModel;
import host.plas.bou.libs.logback.classic.net.ReceiverBase;
import host.plas.bou.libs.logback.core.Context;
import host.plas.bou.libs.logback.core.model.Model;
import host.plas.bou.libs.logback.core.model.processor.ModelHandlerBase;
import host.plas.bou.libs.logback.core.model.processor.ModelHandlerException;
import host.plas.bou.libs.logback.core.model.processor.ModelInterpretationContext;
import host.plas.bou.libs.logback.core.util.OptionHelper;

public class ReceiverModelHandler
extends ModelHandlerBase {
    private ReceiverBase receiver;
    private boolean inError;

    public ReceiverModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new ReceiverModelHandler(context);
    }

    protected Class<ReceiverModel> getSupportedModelClass() {
        return ReceiverModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        ReceiverModel receiverModel = (ReceiverModel)model;
        String className = receiverModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(className)) {
            this.addError("Missing class name for receiver. ");
            this.inError = true;
            return;
        }
        className = mic.getImport(className);
        try {
            this.addInfo("About to instantiate receiver of type [" + className + "]");
            this.receiver = (ReceiverBase)OptionHelper.instantiateByClassName(className, ReceiverBase.class, this.context);
            this.receiver.setContext(this.context);
            mic.pushObject(this.receiver);
        }
        catch (Exception ex) {
            this.inError = true;
            this.addError("Could not create a receiver of type [" + className + "].", ex);
            throw new ModelHandlerException(ex);
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.receiver) {
            this.addWarn("The object at the of the stack is not the receiver pushed earlier.");
        } else {
            mic.popObject();
            this.addInfo("Registering receiver with context.");
            mic.getContext().register(this.receiver);
            this.receiver.start();
        }
    }
}

