/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.core.sift;

import host.plas.bou.libs.logback.core.Appender;
import host.plas.bou.libs.logback.core.Context;
import host.plas.bou.libs.logback.core.joran.ParamModelHandler;
import host.plas.bou.libs.logback.core.joran.spi.DefaultNestedComponentRegistry;
import host.plas.bou.libs.logback.core.joran.spi.JoranException;
import host.plas.bou.libs.logback.core.model.AppenderModel;
import host.plas.bou.libs.logback.core.model.ImplicitModel;
import host.plas.bou.libs.logback.core.model.Model;
import host.plas.bou.libs.logback.core.model.ParamModel;
import host.plas.bou.libs.logback.core.model.PropertyModel;
import host.plas.bou.libs.logback.core.model.SiftModel;
import host.plas.bou.libs.logback.core.model.processor.AppenderModelHandler;
import host.plas.bou.libs.logback.core.model.processor.ImplicitModelHandler;
import host.plas.bou.libs.logback.core.model.processor.ModelInterpretationContext;
import host.plas.bou.libs.logback.core.model.processor.PropertyModelHandler;
import host.plas.bou.libs.logback.core.sift.AppenderFactory;
import host.plas.bou.libs.logback.core.sift.NOPSiftModelHandler;
import host.plas.bou.libs.logback.core.sift.SiftProcessor;
import java.util.Collection;
import java.util.Map;

public class AppenderFactoryUsingSiftModel<E>
implements AppenderFactory<E> {
    Context context;
    final Model siftModel;
    protected String discriminatingKey;
    protected ModelInterpretationContext parentMic;
    protected DefaultNestedComponentRegistry registry;

    public AppenderFactoryUsingSiftModel(ModelInterpretationContext parentMic, Model aSiftModel, String discriminatingKey) {
        this.siftModel = Model.duplicate(aSiftModel);
        this.discriminatingKey = discriminatingKey;
        this.parentMic = parentMic;
        this.context = parentMic.getContext();
    }

    public SiftProcessor<E> getSiftingModelProcessor(String value) {
        ModelInterpretationContext smic = new ModelInterpretationContext(this.parentMic){

            @Override
            public boolean hasDependers(String dependeeName) {
                return true;
            }
        };
        SiftProcessor siftProcessor = new SiftProcessor(this.context, smic);
        siftProcessor.addHandler(ParamModel.class, ParamModelHandler::makeInstance);
        siftProcessor.addHandler(PropertyModel.class, PropertyModelHandler::makeInstance);
        siftProcessor.addHandler(ImplicitModel.class, ImplicitModelHandler::makeInstance);
        siftProcessor.addHandler(AppenderModel.class, AppenderModelHandler::makeInstance);
        siftProcessor.addHandler(SiftModel.class, NOPSiftModelHandler::makeInstance);
        return siftProcessor;
    }

    @Override
    public Appender<E> buildAppender(Context context, String discriminatingValue) throws JoranException {
        SiftProcessor<E> sp = this.getSiftingModelProcessor(discriminatingValue);
        ModelInterpretationContext mic = sp.getModelInterpretationContext();
        sp.setContext(context);
        Model duplicate = Model.duplicate(this.siftModel);
        mic.addSubstitutionProperty(this.discriminatingKey, discriminatingValue);
        sp.process(duplicate);
        Map appenderBag = (Map)mic.getObjectMap().get("APPENDER_BAG");
        Collection values = appenderBag.values();
        if (values.size() == 0) {
            return null;
        }
        return (Appender)values.iterator().next();
    }

    public Model getSiftModel() {
        return this.siftModel;
    }
}

