/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ChannelGroupListener;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionEventTrigger;
import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandEncoder;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.ConnectionInitializer;
import io.lettuce.core.protocol.ConnectionWatchdog;
import io.lettuce.core.protocol.Endpoint;
import io.lettuce.core.protocol.ReconnectionListener;
import io.lettuce.core.protocol.RedisHandshakeHandler;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.EpollProvider;
import io.lettuce.core.resource.IOUringProvider;
import io.lettuce.core.resource.KqueueProvider;
import io.lettuce.core.resource.Transports;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.util.AttributeKey;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.net.ExtendedSocketOptions;
import reactor.core.publisher.Mono;

public class ConnectionBuilder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ConnectionBuilder.class);
    public static final AttributeKey<String> REDIS_URI = AttributeKey.valueOf("RedisURI");
    public static final AttributeKey<Throwable> INIT_FAILURE = AttributeKey.valueOf("ConnectionBuilder.INIT_FAILURE");
    private Mono<SocketAddress> socketAddressSupplier;
    private ConnectionEvents connectionEvents;
    private RedisChannelHandler<?, ?> connection;
    private Endpoint endpoint;
    private Supplier<CommandHandler> commandHandlerSupplier;
    private ChannelGroup channelGroup;
    private Bootstrap bootstrap;
    private ClientOptions clientOptions;
    private Duration timeout;
    private ClientResources clientResources;
    private ConnectionInitializer connectionInitializer;
    private ReconnectionListener reconnectionListener = ReconnectionListener.NO_OP;
    private ConnectionWatchdog connectionWatchdog;
    private RedisURI redisURI;

    public static ConnectionBuilder connectionBuilder() {
        return new ConnectionBuilder();
    }

    public void apply(RedisURI redisURI) {
        this.redisURI = redisURI;
        this.timeout(redisURI.getTimeout());
        this.bootstrap.attr(REDIS_URI, redisURI.toString());
    }

    protected List<ChannelHandler> buildHandlers() {
        LettuceAssert.assertState(this.channelGroup != null, "ChannelGroup must be set");
        LettuceAssert.assertState(this.connectionEvents != null, "ConnectionEvents must be set");
        LettuceAssert.assertState(this.connection != null, "Connection must be set");
        LettuceAssert.assertState(this.clientResources != null, "ClientResources must be set");
        LettuceAssert.assertState(this.endpoint != null, "Endpoint must be set");
        LettuceAssert.assertState(this.connectionInitializer != null, "ConnectionInitializer must be set");
        ArrayList<ChannelHandler> handlers = new ArrayList<ChannelHandler>();
        this.connection.setOptions(this.clientOptions);
        handlers.add(new ChannelGroupListener(this.channelGroup, this.clientResources.eventBus()));
        handlers.add(new CommandEncoder());
        handlers.add(this.getHandshakeHandler());
        handlers.add(this.commandHandlerSupplier.get());
        handlers.add(new ConnectionEventTrigger(this.connectionEvents, this.connection, this.clientResources.eventBus()));
        if (this.clientOptions.isAutoReconnect()) {
            handlers.add(this.createConnectionWatchdog());
        }
        return handlers;
    }

    protected ChannelHandler getHandshakeHandler() {
        return new RedisHandshakeHandler(this.connectionInitializer, this.clientResources, this.timeout);
    }

    protected ConnectionWatchdog createConnectionWatchdog() {
        if (this.connectionWatchdog != null) {
            return this.connectionWatchdog;
        }
        LettuceAssert.assertState(this.bootstrap != null, "Bootstrap must be set for autoReconnect=true");
        LettuceAssert.assertState(this.socketAddressSupplier != null, "SocketAddressSupplier must be set for autoReconnect=true");
        ConnectionWatchdog watchdog = new ConnectionWatchdog(this.clientResources.reconnectDelay(), this.clientOptions, this.bootstrap, this.clientResources.timer(), this.clientResources.eventExecutorGroup(), this.socketAddressSupplier, this.reconnectionListener, this.connection, this.clientResources.eventBus(), this.endpoint);
        this.endpoint.registerConnectionWatchdog(watchdog);
        this.connectionWatchdog = watchdog;
        return watchdog;
    }

    public ChannelInitializer<Channel> build(SocketAddress socketAddress) {
        return new PlainChannelInitializer(this::buildHandlers, this.clientResources);
    }

    public ConnectionBuilder socketAddressSupplier(Mono<SocketAddress> socketAddressSupplier) {
        this.socketAddressSupplier = socketAddressSupplier;
        return this;
    }

    public Mono<SocketAddress> socketAddress() {
        LettuceAssert.assertState(this.socketAddressSupplier != null, "SocketAddressSupplier must be set");
        return this.socketAddressSupplier;
    }

    public ConnectionBuilder timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public ConnectionBuilder reconnectionListener(ReconnectionListener reconnectionListener) {
        LettuceAssert.notNull((Object)reconnectionListener, "ReconnectionListener must not be null");
        this.reconnectionListener = reconnectionListener;
        return this;
    }

    public ConnectionBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ConnectionBuilder connectionEvents(ConnectionEvents connectionEvents) {
        this.connectionEvents = connectionEvents;
        return this;
    }

    public ConnectionBuilder connection(RedisChannelHandler<?, ?> connection) {
        this.connection = connection;
        return this;
    }

    public ConnectionBuilder channelGroup(ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        return this;
    }

    public ConnectionBuilder commandHandler(Supplier<CommandHandler> supplier) {
        this.commandHandlerSupplier = supplier;
        return this;
    }

    public ConnectionBuilder bootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public ConnectionBuilder endpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ConnectionBuilder clientResources(ClientResources clientResources) {
        this.clientResources = clientResources;
        return this;
    }

    public ConnectionBuilder connectionInitializer(ConnectionInitializer connectionInitializer) {
        this.connectionInitializer = connectionInitializer;
        return this;
    }

    public void configureBootstrap(boolean domainSocket, Function<Class<? extends EventLoopGroup>, EventLoopGroup> eventLoopGroupProvider) {
        LettuceAssert.assertState(this.bootstrap != null, "Bootstrap must be set");
        LettuceAssert.assertState(this.clientOptions != null, "ClientOptions must be set");
        Class<? extends EventLoopGroup> eventLoopGroupClass = Transports.eventLoopGroupClass();
        Class<? extends Channel> channelClass = Transports.socketChannelClass();
        if (domainSocket) {
            Transports.NativeTransports.assertDomainSocketAvailable();
            eventLoopGroupClass = Transports.NativeTransports.eventLoopGroupClass(true);
            channelClass = Transports.NativeTransports.domainSocketChannelClass();
        } else {
            this.bootstrap.resolver(this.clientResources.addressResolverGroup());
        }
        SocketOptions options = this.clientOptions.getSocketOptions();
        EventLoopGroup eventLoopGroup = eventLoopGroupProvider.apply(eventLoopGroupClass);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, Math.toIntExact(options.getConnectTimeout().toMillis()));
        if (!domainSocket) {
            this.bootstrap.option(ChannelOption.SO_KEEPALIVE, options.isKeepAlive());
            this.bootstrap.option(ChannelOption.TCP_NODELAY, options.isTcpNoDelay());
            if (options.isEnableTcpUserTimeout()) {
                SocketOptions.TcpUserTimeoutOptions tcpUserTimeoutOptions = options.getTcpUserTimeout();
                if (IOUringProvider.isAvailable()) {
                    IOUringProvider.applyTcpUserTimeout(this.bootstrap, tcpUserTimeoutOptions.getTcpUserTimeout());
                } else if (EpollProvider.isAvailable()) {
                    EpollProvider.applyTcpUserTimeout(this.bootstrap, tcpUserTimeoutOptions.getTcpUserTimeout());
                } else {
                    logger.warn("Cannot apply TCP User Timeout options to channel type " + channelClass.getName());
                }
            }
        }
        ((Bootstrap)this.bootstrap.channel(channelClass)).group(eventLoopGroup);
        if (options.isKeepAlive() && options.isExtendedKeepAlive()) {
            SocketOptions.KeepAliveOptions keepAlive = options.getKeepAlive();
            if (IOUringProvider.isAvailable()) {
                IOUringProvider.applyKeepAlive(this.bootstrap, keepAlive.getCount(), keepAlive.getIdle(), keepAlive.getInterval());
            } else if (EpollProvider.isAvailable()) {
                EpollProvider.applyKeepAlive(this.bootstrap, keepAlive.getCount(), keepAlive.getIdle(), keepAlive.getInterval());
            } else if (ExtendedNioSocketOptions.isAvailable() && !KqueueProvider.isAvailable()) {
                ExtendedNioSocketOptions.applyKeepAlive(this.bootstrap, keepAlive.getCount(), keepAlive.getIdle(), keepAlive.getInterval());
            } else {
                logger.warn("Cannot apply extended TCP keepalive options to channel type " + channelClass.getName());
            }
        }
    }

    public RedisChannelHandler<?, ?> connection() {
        return this.connection;
    }

    public Bootstrap bootstrap() {
        return this.bootstrap;
    }

    public ClientOptions clientOptions() {
        return this.clientOptions;
    }

    public ClientResources clientResources() {
        return this.clientResources;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public RedisURI getRedisURI() {
        return this.redisURI;
    }

    static class ExtendedNioSocketOptions {
        private static final SocketOption<Integer> TCP_KEEPCOUNT;
        private static final SocketOption<Integer> TCP_KEEPIDLE;
        private static final SocketOption<Integer> TCP_KEEPINTERVAL;

        ExtendedNioSocketOptions() {
        }

        public static boolean isAvailable() {
            return TCP_KEEPCOUNT != null && TCP_KEEPIDLE != null && TCP_KEEPINTERVAL != null;
        }

        public static void applyKeepAlive(Bootstrap bootstrap, int count, Duration idle, Duration interval) {
            bootstrap.option(NioChannelOption.of(TCP_KEEPCOUNT), count);
            bootstrap.option(NioChannelOption.of(TCP_KEEPIDLE), Math.toIntExact(idle.getSeconds()));
            bootstrap.option(NioChannelOption.of(TCP_KEEPINTERVAL), Math.toIntExact(interval.getSeconds()));
        }

        static {
            SocketOption keepCount = null;
            SocketOption keepIdle = null;
            SocketOption keepInterval = null;
            try {
                keepCount = (SocketOption)ExtendedSocketOptions.class.getDeclaredField("TCP_KEEPCOUNT").get(null);
                keepIdle = (SocketOption)ExtendedSocketOptions.class.getDeclaredField("TCP_KEEPIDLE").get(null);
                keepInterval = (SocketOption)ExtendedSocketOptions.class.getDeclaredField("TCP_KEEPINTERVAL").get(null);
            }
            catch (ReflectiveOperationException e) {
                logger.trace("Cannot extract ExtendedSocketOptions for KeepAlive", e);
            }
            TCP_KEEPCOUNT = keepCount;
            TCP_KEEPIDLE = keepIdle;
            TCP_KEEPINTERVAL = keepInterval;
        }
    }

    static class PlainChannelInitializer
    extends ChannelInitializer<Channel> {
        private final Supplier<List<ChannelHandler>> handlers;
        private final ClientResources clientResources;

        PlainChannelInitializer(Supplier<List<ChannelHandler>> handlers, ClientResources clientResources) {
            this.handlers = handlers;
            this.clientResources = clientResources;
        }

        @Override
        protected void initChannel(Channel channel) {
            this.doInitialize(channel);
        }

        private void doInitialize(Channel channel) {
            for (ChannelHandler handler : this.handlers.get()) {
                channel.pipeline().addLast(handler);
            }
            this.clientResources.nettyCustomizer().afterChannelInitialized(channel);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.channel().attr(INIT_FAILURE).set(cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

