/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.OutputFactory;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class NumberListOutput<K, V>
extends CommandOutput<K, V, List<Number>> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(NumberListOutput.class);
    private boolean initialized;

    public NumberListOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
    }

    @Override
    public void set(ByteBuffer bytes) {
        ((List)this.output).add(bytes != null ? (Number)this.parseNumber(bytes) : (Number)null);
    }

    @Override
    public void set(double number) {
        ((List)this.output).add(number);
    }

    @Override
    public void set(long integer) {
        ((List)this.output).add(integer);
    }

    @Override
    public void setBigNumber(ByteBuffer bytes) {
        ((List)this.output).add(bytes != null ? (Number)this.parseNumber(bytes) : (Number)null);
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    private Number parseNumber(ByteBuffer bytes) {
        Number result = 0;
        try {
            result = NumberFormat.getNumberInstance().parse(this.decodeString(bytes));
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse " + bytes, e);
        }
        return result;
    }
}

