/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.api.base.commands;

import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.Singularity;
import singularity.command.CosmicCommand;
import singularity.command.context.CommandContext;
import singularity.configs.given.MainMessagesHandler;
import singularity.data.players.CosmicPlayer;
import singularity.utils.UserUtils;

public class PlaytimeCommand
extends CosmicCommand {
    private final String messageGet = (String)this.getCommandResource().getOrSetDefault("messages.playtime.get", "&d%streamline_parse_%this_other%:::*/*streamline_user_formatted*/*%&e&8'&es &cplaytime&8: &r%streamline_user_play_seconds% &dseconds");
    private final String messageSet = (String)this.getCommandResource().getOrSetDefault("messages.playtime.set", "&eSet &d%streamline_parse_%this_other%:::*/*streamline_user_formatted*/*%&e&8'&es &cplaytime &eto &a%this_value% &dseconds&8!");
    private final String messageAdd = (String)this.getCommandResource().getOrSetDefault("messages.playtime.add", "&eAdded &a%this_value% &dseconds &eto &d%streamline_parse_%this_other%:::*/*streamline_user_formatted*/*%&e&8'&es &cplaytime&8!");
    private final String messageRemove = (String)this.getCommandResource().getOrSetDefault("messages.playtime.remove", "&eRemoved &a%this_value% &dseconds &efrom &d%streamline_parse_%this_other%:::*/*streamline_user_formatted*/*%&e&8'&es &cplaytime&8!");

    public PlaytimeCommand() {
        super("streamline-base", "proxyplaytime", "streamline.command.playtime.default", "pplaytime", "pplay", "proxyplay");
    }

    @Override
    public void run(CommandContext<CosmicCommand> context) {
        if (context.getArgCount() < 1) {
            context.sendMessage(MainMessagesHandler.MESSAGES.INVALID.ARGUMENTS_TOO_FEW.get());
            return;
        }
        String playerName = context.getStringArg(0);
        CosmicPlayer other = UserUtils.getOrCreatePlayerByName(playerName).orElse(null);
        if (other == null) {
            context.sendMessage(MainMessagesHandler.MESSAGES.INVALID.USER_OTHER.get());
            return;
        }
        if (context.getArgCount() == 1) {
            context.sendMessage(this.getWithOther(context.getSender(), this.messageGet, playerName));
            return;
        }
        String action = context.getStringArg(1);
        int amount = 0;
        try {
            amount = Integer.parseInt(context.getStringArg(2));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.sendMessage(MainMessagesHandler.MESSAGES.INVALID.ARGUMENTS_TYPE_NUMBER.get());
            return;
        }
        switch (action) {
            case "set": {
                other.setPlaySeconds(amount);
                context.sendMessage(this.getWithOther(context.getSender(), this.messageSet, other));
                break;
            }
            case "add": {
                other.addPlaySeconds(amount);
                context.sendMessage(this.getWithOther(context.getSender(), this.messageAdd, other));
                break;
            }
            case "remove": {
                other.removePlaySecond(amount);
                context.sendMessage(this.getWithOther(context.getSender(), this.messageRemove, other));
                break;
            }
            default: {
                context.sendMessage(MainMessagesHandler.MESSAGES.INVALID.ARGUMENTS_TYPE_DEFAULT.get());
            }
        }
    }

    @Override
    public ConcurrentSkipListSet<String> doTabComplete(CommandContext<CosmicCommand> context) {
        if (context.getArgCount() <= 1) {
            return Singularity.getInstance().getPlatform().getOnlinePlayerNames();
        }
        if (context.getArgCount() == 2) {
            return new ConcurrentSkipListSet<String>(List.of("set", "add", "remove"));
        }
        if (context.getArgCount() == 3) {
            return this.getIntegerArgument();
        }
        return new ConcurrentSkipListSet<String>();
    }
}

