/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.api.base.ratapi;

import gg.drak.thebase.objects.AtomicString;
import java.util.Optional;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.query.QueryOptions;
import net.streamline.api.base.module.BaseModule;
import singularity.placeholders.expansions.RATExpansion;
import singularity.placeholders.replaceables.IdentifiedUserReplaceable;
import singularity.utils.UserUtils;

public class LuckpermsExpansion
extends RATExpansion {
    public LuckpermsExpansion() {
        super(new RATExpansion.RATExpansionBuilder("luckperms"));
        BaseModule.getInstance().logInfo(this.getClass().getSimpleName() + " is registered!");
    }

    @Override
    public void init() {
        new IdentifiedUserReplaceable(this, "prefix", (s2, user) -> UserUtils.getPrefix(user)).register();
        new IdentifiedUserReplaceable(this, "suffix", (s2, user) -> UserUtils.getSuffix(user)).register();
        new IdentifiedUserReplaceable(this, "primary_group", (s2, user) -> {
            UUID uuid = null;
            try {
                uuid = UUID.fromString(user.getUuid());
                if (uuid == null) {
                    return s2.string();
                }
            }
            catch (Exception e) {
                return s2.string();
            }
            try {
                LuckPerms api = LuckPermsProvider.get();
                User u = api.getUserManager().getUser(uuid);
                if (u == null) {
                    return s2.string();
                }
                return u.getPrimaryGroup();
            }
            catch (Exception e) {
                try {
                    return s2.string();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return s2.string();
                }
            }
        }).register();
        new IdentifiedUserReplaceable(this, "highest_group", (s2, user) -> {
            UUID uuid = null;
            try {
                uuid = UUID.fromString(user.getUuid());
                if (uuid == null) {
                    return s2.string();
                }
            }
            catch (Exception e) {
                return s2.string();
            }
            try {
                LuckPerms api = LuckPermsProvider.get();
                User u = api.getUserManager().getUser(uuid);
                if (u == null) {
                    return s2.string();
                }
                Optional group = u.getInheritedGroups(QueryOptions.builder((QueryMode)QueryMode.CONTEXTUAL).build()).stream().findFirst();
                return group.map(Group::getName).orElse(s2.string());
            }
            catch (Exception e) {
                try {
                    return s2.string();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return s2.string();
                }
            }
        }).register();
        new IdentifiedUserReplaceable(this, "[m][e][t][a][_](.*?)", 1, (s2, user) -> {
            UUID uuid;
            String params = s2.get();
            try {
                uuid = UUID.fromString(user.getUuid());
            }
            catch (Exception e) {
                return s2.string();
            }
            try {
                LuckPerms api = LuckPermsProvider.get();
                User u = api.getUserManager().getUser(uuid);
                if (u == null) {
                    return s2.string();
                }
                AtomicString s1 = new AtomicString("");
                u.getNodes(NodeType.META).forEach(node -> {
                    if (node.getMetaKey().equals(params)) {
                        s1.set((Object)node.getMetaValue());
                    }
                });
                if (!((String)s1.get()).isEmpty() || !((String)s1.get()).isBlank()) {
                    return (String)s1.get();
                }
                Group group = api.getGroupManager().getGroup(u.getPrimaryGroup());
                if (group == null) {
                    return s2.string();
                }
                group.getNodes(NodeType.META).forEach(node -> {
                    if (node.getMetaKey().equals(params)) {
                        s1.set((Object)node.getMetaValue());
                    }
                });
                if (!((String)s1.get()).isEmpty() || !((String)s1.get()).isBlank()) {
                    return (String)s1.get();
                }
                return s2.string();
            }
            catch (Exception e) {
                try {
                    return s2.string();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    return s2.string();
                }
            }
        }).register();
    }
}

