/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.api.base.ratapi;

import gg.drak.thebase.utils.MatcherUtils;
import java.util.ArrayList;
import java.util.Optional;
import net.streamline.api.base.module.BaseModule;
import singularity.Singularity;
import singularity.configs.given.MainMessagesHandler;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.modules.ModuleManager;
import singularity.modules.ModuleUtils;
import singularity.placeholders.expansions.RATExpansion;
import singularity.placeholders.replaceables.IdentifiedReplaceable;
import singularity.placeholders.replaceables.IdentifiedUserReplaceable;
import singularity.utils.UserUtils;

public class StreamlineExpansion
extends RATExpansion {
    public StreamlineExpansion() {
        super(new RATExpansion.RATExpansionBuilder("streamline"));
        BaseModule.getInstance().logInfo(this.getClass().getSimpleName() + " is registered!");
    }

    @Override
    public void init() {
        new IdentifiedReplaceable(this, "version", s2 -> Singularity.getInstance().getPlatform().getVersion()).register();
        new IdentifiedReplaceable(this, "players_max", s2 -> String.valueOf(Singularity.getInstance().getPlatform().getMaxPlayers())).register();
        new IdentifiedReplaceable(this, "players_online", s2 -> String.valueOf(UserUtils.getOnlinePlayers().size())).register();
        new IdentifiedReplaceable(this, "users_online", s2 -> String.valueOf(UserUtils.getOnlineSenders().size())).register();
        new IdentifiedReplaceable(this, "players_loaded", s2 -> String.valueOf(UserUtils.getLoadedPlayers().size())).register();
        new IdentifiedReplaceable(this, "users_loaded", s2 -> String.valueOf(UserUtils.getLoadedSenders().size())).register();
        new IdentifiedReplaceable(this, "modules_loaded", s2 -> ModuleUtils.getListAsFormattedString(new ArrayList<String>(ModuleManager.getLoadedModuleIdentifiers()))).register();
        new IdentifiedReplaceable(this, "modules_enabled", s2 -> ModuleUtils.getListAsFormattedString(new ArrayList<String>(ModuleManager.getEnabledModuleIdentifiers()))).register();
        new IdentifiedReplaceable(this, "modules_colorized", s2 -> ModuleUtils.getListAsFormattedString(new ArrayList<String>(ModuleManager.getColorizedLoadedModuleIdentifiers()))).register();
        new IdentifiedReplaceable(this, "modules_loaded_count", s2 -> String.valueOf(ModuleManager.getLoadedModuleIdentifiers().size())).register();
        new IdentifiedReplaceable(this, "modules_enabled_count", s2 -> String.valueOf(ModuleManager.getEnabledModuleIdentifiers().size())).register();
        new IdentifiedReplaceable(this, "modules_colorized_count", s2 -> String.valueOf(ModuleManager.getColorizedLoadedModuleIdentifiers().size())).register();
        new IdentifiedReplaceable(this, "null", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.IS_NULL.get()).register();
        new IdentifiedReplaceable(this, "true", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.IS_TRUE.get()).register();
        new IdentifiedReplaceable(this, "false", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.IS_FALSE.get()).register();
        new IdentifiedReplaceable(this, "online", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.IS_ONLINE.get()).register();
        new IdentifiedReplaceable(this, "offline", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.IS_OFFLINE.get()).register();
        new IdentifiedReplaceable(this, "placeholders_null", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_NULL.get()).register();
        new IdentifiedReplaceable(this, "placeholders_true", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_TRUE.get()).register();
        new IdentifiedReplaceable(this, "placeholders_false", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_FALSE.get()).register();
        new IdentifiedReplaceable(this, "placeholders_online", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_ONLINE.get()).register();
        new IdentifiedReplaceable(this, "placeholders_offline", s2 -> MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_OFFLINE.get()).register();
        new IdentifiedReplaceable(this, MatcherUtils.makeLiteral((String)"parse_") + "(.*?)", 1, s2 -> {
            try {
                if (s2.get().contains(":::")) {
                    String[] things = s2.get().split(":::", 2);
                    Optional<CosmicSender> userOptional = UserUtils.getOrCreateSenderByName(things[0]);
                    if (userOptional.isEmpty()) {
                        return s2.string();
                    }
                    String parse = things[1].replace("*/*", "%");
                    return ModuleUtils.replacePlaceholders(userOptional.get(), parse);
                }
                return ModuleUtils.replacePlaceholders(s2.get());
            }
            catch (Exception e) {
                e.printStackTrace();
                return s2.string();
            }
        }).register();
        new IdentifiedReplaceable(this, "[?][L][:](.*?)", 1, s2 -> {
            try {
                String params = s2.get();
                params = params.replace("[[", "%").replace("]]", "%").replace("{{", "%").replace("}}", "%").replace("*/*", "%");
                return ModuleUtils.parseOnProxy(params);
            }
            catch (Exception e) {
                e.printStackTrace();
                return s2.string();
            }
        }).register();
        new IdentifiedUserReplaceable(this, "user_ping", (s2, user) -> {
            if (user.isConsole()) {
                return MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_OFFLINE.get();
            }
            return String.valueOf(Singularity.getInstance().getUserManager().getPlayerPing(user.getUuid()));
        }).register();
        new IdentifiedUserReplaceable(this, "user_online", (s2, user) -> user.isOnline() ? MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_ONLINE.get() : MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_OFFLINE.get()).register();
        new IdentifiedUserReplaceable(this, "user_uuid", (s2, user) -> user.getUuid()).register();
        new IdentifiedUserReplaceable(this, "user_absolute", (s2, user) -> UserUtils.getAbsolute(user)).register();
        new IdentifiedUserReplaceable(this, "user_absolute_onlined", (s2, user) -> UserUtils.getOffOnAbsolute(user)).register();
        new IdentifiedUserReplaceable(this, "user_formatted", (s2, user) -> UserUtils.getFormatted(user)).register();
        new IdentifiedUserReplaceable(this, "user_formatted_onlined", (s2, user) -> UserUtils.getOffOnFormatted(user)).register();
        new IdentifiedUserReplaceable(this, "user_prefix", (s2, user) -> UserUtils.getPrefix(user)).register();
        new IdentifiedUserReplaceable(this, "user_suffix", (s2, user) -> UserUtils.getSuffix(user)).register();
        new IdentifiedUserReplaceable(this, "user_play_seconds", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getPlaySecondsAsString()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_play_minutes", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getPlayMinutesAsString()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_play_hours", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getPlayHoursAsString()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_play_days", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getPlayDaysAsString()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_ip", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getCurrentIp()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_server", (s2, user) -> String.valueOf(user.getServerName())).register();
        new IdentifiedUserReplaceable(this, "user_tags", (s2, user) -> user.getMeta().getTagsAsString()).register();
        new IdentifiedUserReplaceable(this, "user_location_server", (s2, user) -> user.getServerName()).register();
        new IdentifiedUserReplaceable(this, "user_location_world", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getWorld()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_location_x", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getX()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_location_y", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getY()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_location_z", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getZ()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_location_pitch", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getPitch()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "user_location_yaw", (s2, user) -> user instanceof CosmicPlayer ? String.valueOf(((CosmicPlayer)user).getYaw()) : s2.string()).register();
        new IdentifiedUserReplaceable(this, "[?][R][:](.*?)", 1, (s2, user) -> {
            try {
                String params = s2.get();
                params = params.replace("[[", "%").replace("]]", "%").replace("{{", "%").replace("}}", "%").replace("*/*", "%");
                return ModuleUtils.parseOnProxy(user, params);
            }
            catch (Exception e) {
                e.printStackTrace();
                return s2.string();
            }
        }).register();
    }
}

