/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.api.permissions;

import gg.drak.thebase.objects.AtomicString;
import gg.drak.thebase.utils.MathUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import net.streamline.api.SLAPI;
import singularity.data.players.CosmicPlayer;
import singularity.data.uuid.UuidManager;
import singularity.permissions.MetaGrabber;
import singularity.permissions.MetaKey;
import singularity.permissions.MetaValue;
import singularity.utils.UUIDFetcher;

public class MetaGrabberImpl
implements MetaGrabber {
    public static Optional<LuckPerms> tryGetLuckPerms() {
        SLAPI.tryGetLuckPerms();
        return SLAPI.getLpOptional();
    }

    public static void withLuckPerms(Consumer<LuckPerms> consumer) {
        SLAPI.withLuckPerms(consumer);
    }

    @Override
    public Optional<MetaValue> getPrefix(CosmicPlayer player) {
        String username = player.getCurrentName();
        AtomicString prefix = new AtomicString("");
        AtomicInteger priority = new AtomicInteger(0);
        MetaGrabberImpl.withLuckPerms(luckPerms -> {
            ConcurrentSkipListMap<Integer, String> preWeight;
            String uuid = "";
            Optional<String> s2 = UuidManager.getUuidFromName(username);
            if (s2.isEmpty()) {
                UUID u = UUIDFetcher.getUUID(username);
                if (u != null) {
                    uuid = u.toString();
                }
            } else {
                uuid = s2.get();
            }
            if (Objects.equals(uuid, "")) {
                return;
            }
            User user = luckPerms.getUserManager().getUser(UUID.fromString(uuid));
            Group group = luckPerms.getGroupManager().getGroup(user.getPrimaryGroup());
            if (group == null) {
                preWeight = new ConcurrentSkipListMap<Integer, String>();
                for (PrefixNode node : user.getNodes(NodeType.PREFIX)) {
                    preWeight.put(node.getPriority(), node.getMetaValue());
                }
                prefix.set((Object)((String)preWeight.get(MathUtils.getCeilingInt((Set)preWeight.keySet()))));
                priority.set(MathUtils.getCeilingInt((Set)preWeight.keySet()));
                if (prefix.get() == null) {
                    prefix.set((Object)"");
                }
                if (priority.get() == 0) {
                    priority.set(0);
                }
            }
            preWeight = new ConcurrentSkipListMap();
            for (PrefixNode node : group.getNodes(NodeType.PREFIX)) {
                preWeight.put(node.getPriority(), node.getMetaValue());
            }
            for (PrefixNode node : user.getNodes(NodeType.PREFIX)) {
                preWeight.put(node.getPriority(), node.getMetaValue());
            }
            prefix.set((Object)((String)preWeight.get(MathUtils.getCeilingInt((Set)preWeight.keySet()))));
            priority.set(MathUtils.getCeilingInt((Set)preWeight.keySet()));
            if (prefix.get() == null) {
                prefix.set((Object)"");
            }
            if (priority.get() == 0) {
                priority.set(0);
            }
        });
        MetaValue metaValue = new MetaValue(player.getIdentifier(), MetaKey.PREFIX, (String)prefix.get(), -1L, 0);
        return Optional.of(metaValue);
    }

    @Override
    public Optional<MetaValue> getSuffix(CosmicPlayer player) {
        String username = player.getCurrentName();
        AtomicString suffix = new AtomicString("");
        AtomicInteger priority = new AtomicInteger(0);
        MetaGrabberImpl.withLuckPerms(luckPerms -> {
            ConcurrentSkipListMap<Integer, String> sufWeight;
            String uuid = "";
            Optional<String> s2 = UuidManager.getUuidFromName(username);
            if (s2.isEmpty()) {
                UUID u = UUIDFetcher.getUUID(username);
                if (u != null) {
                    uuid = u.toString();
                }
            } else {
                uuid = s2.get();
            }
            if (Objects.equals(uuid, "")) {
                return;
            }
            User user = luckPerms.getUserManager().getUser(UUID.fromString(uuid));
            Group group = luckPerms.getGroupManager().getGroup(user.getPrimaryGroup());
            if (group == null) {
                sufWeight = new ConcurrentSkipListMap<Integer, String>();
                for (SuffixNode node : user.getNodes(NodeType.SUFFIX)) {
                    sufWeight.put(node.getPriority(), node.getMetaValue());
                }
                suffix.set((Object)((String)sufWeight.get(MathUtils.getCeilingInt((Set)sufWeight.keySet()))));
                priority.set(MathUtils.getCeilingInt((Set)sufWeight.keySet()));
                if (suffix.get() == null) {
                    suffix.set((Object)"");
                }
                if (priority.get() == 0) {
                    priority.set(0);
                }
            }
            sufWeight = new ConcurrentSkipListMap();
            for (SuffixNode node : group.getNodes(NodeType.SUFFIX)) {
                sufWeight.put(node.getPriority(), node.getMetaValue());
            }
            for (SuffixNode node : user.getNodes(NodeType.SUFFIX)) {
                sufWeight.put(node.getPriority(), node.getMetaValue());
            }
            suffix.set((Object)((String)sufWeight.get(MathUtils.getCeilingInt((Set)sufWeight.keySet()))));
            priority.set(MathUtils.getCeilingInt((Set)sufWeight.keySet()));
            if (suffix.get() == null) {
                suffix.set((Object)"");
            }
            if (priority.get() == 0) {
                priority.set(0);
            }
        });
        MetaValue metaValue = new MetaValue(player.getIdentifier(), MetaKey.SUFFIX, (String)suffix.get(), -1L, 0);
        return Optional.of(metaValue);
    }

    @Override
    public void setMeta(MetaValue value) {
    }
}

