/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform;

import gg.drak.thebase.events.BaseEventHandler;
import gg.drak.thebase.events.components.BaseEvent;
import host.plas.bou.BetterPlugin;
import host.plas.bou.libs.universalScheduler.UniversalScheduler;
import host.plas.bou.libs.universalScheduler.scheduling.schedulers.TaskScheduler;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.streamline.api.SLAPI;
import net.streamline.api.base.module.BaseModule;
import net.streamline.apib.SLAPIB;
import net.streamline.base.runnables.PlayerChecker;
import net.streamline.platform.Messenger;
import net.streamline.platform.commands.ProperCommand;
import net.streamline.platform.handlers.BackendHandler;
import net.streamline.platform.listeners.PlatformListener;
import net.streamline.platform.messaging.ProxyPluginMessenger;
import net.streamline.platform.savables.ConsoleHolder;
import net.streamline.platform.savables.PlayerInterface;
import net.streamline.platform.savables.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import singularity.Singularity;
import singularity.command.CosmicCommand;
import singularity.data.players.CosmicPlayer;
import singularity.data.players.location.PlayerRotation;
import singularity.data.players.location.PlayerWorld;
import singularity.data.players.location.WorldPosition;
import singularity.data.uuid.UuidInfo;
import singularity.data.uuid.UuidManager;
import singularity.events.CosmicEvent;
import singularity.events.server.ServerStopEvent;
import singularity.interfaces.IProperEvent;
import singularity.interfaces.ISingularityExtension;
import singularity.logging.CosmicLogHandler;
import singularity.objects.CosmicResourcePack;
import singularity.scheduler.TaskManager;
import singularity.utils.MessageUtils;
import singularity.utils.StorageUtils;
import singularity.utils.UserUtils;

public abstract class BasePlugin
extends BetterPlugin
implements ISingularityExtension {
    private final ISingularityExtension.PlatformType platformType = ISingularityExtension.PlatformType.SPIGOT;
    private final ISingularityExtension.ServerType serverType = ISingularityExtension.ServerType.BACKEND;
    private CosmicResourcePack resourcePack;
    private String version;
    private String folderName;
    private static BasePlugin instance;
    private SLAPI<CommandSender, Player, BasePlugin, UserManager, Messenger> slapi;
    private SLAPIB slapiB;
    private UserManager userManager;
    private Messenger messenger;
    private ConsoleHolder consoleHolder;
    private PlayerInterface playerInterface;
    private static PlayerChecker playerChecker;
    private static TaskScheduler scheduler;
    private static PlatformListener.ProxyMessagingListener proxyMessagingListener;
    private static boolean commandsNeedToBeSynced;
    private static CommandMap commandMap;

    public Server getProxy() {
        return this.getServer();
    }

    public void onBaseConstruct() {
        File parentFile;
        File[] files;
        instance = this;
        scheduler = UniversalScheduler.getScheduler((Plugin)this);
        this.setupProperties();
        String parentPath = this.getDataFolder().getParent();
        if (parentPath != null && (files = (parentFile = new File(parentPath)).listFiles(f -> {
            if (!f.isDirectory()) {
                return false;
            }
            if (f.getName().equals("StreamlineAPI")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Spigot")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Bungee")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Velocity")) {
                return true;
            }
            return f.getName().equals("streamlinecore");
        })) != null) {
            Arrays.stream(files).forEach(file -> file.renameTo(new File(parentPath, this.folderName)));
        }
        this.load();
    }

    public void setupProperties() {
        ConcurrentSkipListMap<String, String> properties = StorageUtils.readProperties();
        if (properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("name")) {
                this.folderName = value;
            }
            if (!key.equals("version")) continue;
            this.version = value;
        }
    }

    public void onBaseEnabled() {
        BasePlugin.setupCommandMap();
        this.getLogger().addHandler(new CosmicLogHandler());
        this.userManager = new UserManager();
        this.messenger = new Messenger();
        this.consoleHolder = new ConsoleHolder();
        this.playerInterface = new PlayerInterface();
        this.slapi = new SLAPI<CommandSender, Player, BasePlugin, UserManager, Messenger>(this.getFolderName(), this, this.getUserManager(), this.getMessenger(), this.getConsoleHolder(), this.getPlayerInterface(), BaseModule::new);
        SLAPI.setBackendHandler(new BackendHandler());
        this.slapiB = new SLAPIB(this.getSlapi(), (JavaPlugin)this);
        this.getSlapi().setProxyMessenger(new ProxyPluginMessenger());
        TaskManager.init();
        proxyMessagingListener = new PlatformListener.ProxyMessagingListener();
        this.getProxy().getMessenger().registerOutgoingPluginChannel((Plugin)this, SLAPI.getApiChannel());
        this.getProxy().getMessenger().registerIncomingPluginChannel((Plugin)this, SLAPI.getApiChannel(), (PluginMessageListener)proxyMessagingListener);
        playerChecker = new PlayerChecker();
        this.enable();
        this.registerListener(new PlatformListener());
    }

    public void onBaseDisable() {
        Singularity.getTpTicketFlusher().cancel();
        Singularity.getTpTicketPuller().cancel();
        UserUtils.syncAllUsers();
        UuidManager.getUuids().forEach(UuidInfo::save);
        this.getProxy().getMessenger().unregisterOutgoingPluginChannel((Plugin)this, SLAPI.getApiChannel());
        this.getProxy().getMessenger().unregisterIncomingPluginChannel((Plugin)this, SLAPI.getApiChannel());
        this.disable();
        this.fireStopEvent();
        TaskManager.stop();
    }

    public void fireStopEvent() {
        ServerStopEvent e = (ServerStopEvent)new ServerStopEvent().fire();
        if (e.isCancelled()) {
            return;
        }
        if (!e.isSendable()) {
            return;
        }
        SLAPI.sendConsoleMessage(e.getMessage());
    }

    public abstract void enable();

    public abstract void disable();

    public abstract void load();

    public abstract void reload();

    @Override
    @NotNull
    public ConcurrentSkipListSet<CosmicPlayer> getOnlinePlayers() {
        ConcurrentSkipListSet<CosmicPlayer> players = new ConcurrentSkipListSet<CosmicPlayer>();
        for (Player player : BasePlugin.onlinePlayers()) {
            CosmicPlayer cosmicPlayer;
            if (!UserUtils.isLoaded(player.getUniqueId().toString()) || (cosmicPlayer = (CosmicPlayer)this.getUserManager().getOrCreatePlayer(player).orElse(null)) == null) continue;
            players.add(cosmicPlayer);
        }
        return players;
    }

    @Override
    public ProperCommand createCommand(CosmicCommand command) {
        return new ProperCommand(command);
    }

    @Override
    public int getMaxPlayers() {
        return BasePlugin.getInstance().getProxy().getMaxPlayers();
    }

    @Override
    public ConcurrentSkipListSet<String> getOnlinePlayerNames() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        this.getOnlinePlayers().forEach(a -> r.add(a.getCurrentName()));
        return r;
    }

    @Override
    public boolean isOfflineMode() {
        return !Bukkit.getOnlineMode();
    }

    @Override
    public long getConnectionThrottle() {
        return BasePlugin.getInstance().getProxy().getConnectionThrottle();
    }

    public static List<Player> onlinePlayers() {
        return new ArrayList<Player>(BasePlugin.getInstance().getProxy().getOnlinePlayers());
    }

    public static List<Player> playersOnServer(String serverName) {
        return new ArrayList<Player>();
    }

    public static Player getPlayer(String uuid) {
        for (Player player : BasePlugin.onlinePlayers()) {
            if (!player.getUniqueId().toString().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static Optional<Player> getPlayerByName(String name) {
        return Optional.ofNullable(BasePlugin.getInstance().getProxy().getPlayer(name));
    }

    @Nullable
    public static Player getPlayerExact(@NotNull String name) {
        if (BasePlugin.getPlayerByName(name).isEmpty()) {
            return null;
        }
        return BasePlugin.getPlayerByName(name).get();
    }

    @NotNull
    public static List<Player> matchPlayer(@NotNull String name) {
        Player player = BasePlugin.getPlayerExact(name);
        if (player == null) {
            return new ArrayList<Player>();
        }
        return List.of(player);
    }

    @Nullable
    public static Player getPlayer(@NotNull UUID id) {
        return BasePlugin.getPlayer(id.toString());
    }

    public static Player getPlayer(CommandSender sender) {
        return BasePlugin.getInstance().getProxy().getPlayer(sender.getName());
    }

    @Override
    public boolean getOnlineMode() {
        return BasePlugin.getInstance().getProxy().getOnlineMode();
    }

    @Override
    public void shutdown() {
        BasePlugin.getInstance().getProxy().shutdown();
    }

    @Override
    public int broadcast(@NotNull String message, @NotNull String permission) {
        int people = 0;
        for (Player player : BasePlugin.onlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            this.getMessenger().sendMessage((CommandSender)player, message);
            ++people;
        }
        return people;
    }

    @Override
    public boolean serverHasPlugin(String plugin) {
        return BasePlugin.getInstance().getProxy().getPluginManager().getPlugin(plugin) != null;
    }

    @Override
    public boolean equalsAnyServer(String servername) {
        return this.getServerNames().contains(servername);
    }

    @Override
    public void fireEvent(IProperEvent<?> event) {
        if (!(event.getEvent() instanceof Event)) {
            return;
        }
        Event e = (Event)event.getEvent();
        BasePlugin.getInstance().getProxy().getPluginManager().callEvent(e);
    }

    @Override
    public void fireEvent(CosmicEvent event) {
        this.fireEvent(event, true);
    }

    @Override
    public void fireEvent(CosmicEvent event, boolean async) {
        try {
            BaseEventHandler.fireEvent((BaseEvent)event);
        }
        catch (Exception e) {
            this.handleMisSync(event, async);
        }
    }

    @Override
    public void handleMisSync(CosmicEvent event, boolean async) {
        BaseEventHandler.fireEvent((BaseEvent)event);
    }

    @Override
    public ConcurrentSkipListSet<String> getServerNames() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        return r;
    }

    @Override
    public void sendResourcePack(CosmicResourcePack resourcePack, CosmicPlayer player) {
        Player p = BasePlugin.getPlayer(player.getUuid());
        this.sendResourcePack(resourcePack, p);
    }

    @Override
    public void sendResourcePack(CosmicResourcePack resourcePack, String uuid) {
        Player p = BasePlugin.getPlayer(uuid);
        this.sendResourcePack(resourcePack, p);
    }

    public void sendResourcePack(CosmicResourcePack resourcePack, Player player) {
        if (player == null) {
            MessageUtils.logWarning("Tried to send a player a resource pack, but could not find their player!");
            return;
        }
        try {
            if (resourcePack.getHash().length > 0) {
                player.setResourcePack(resourcePack.getUrl(), resourcePack.getHash());
                return;
            }
            player.setResourcePack(resourcePack.getUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ClassLoader getMainClassLoader() {
        return this.getProxy().getClass().getClassLoader();
    }

    private static void setupCommandMap() {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerCommands(ProperCommand ... commands) {
        try {
            for (ProperCommand command : commands) {
                commandMap.register(command.getParent().getBase(), command.getLabel(), (Command)command);
                try {
                    commandMap.register("streamlinecore", (Command)command);
                }
                catch (Throwable e) {
                    MessageUtils.logDebugWithInfo("Failed to register command: " + command.getLabel(), e);
                }
            }
            CompletableFuture.runAsync(BasePlugin::syncCommands);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void unregisterCommands(String ... commands) {
        try {
            for (String command : commands) {
                Command com = commandMap.getCommand(command);
                if (com == null) {
                    MessageUtils.logDebug("Tried to unregister a command that does not exist: " + command);
                    continue;
                }
                try {
                    com.unregister(commandMap);
                }
                catch (Throwable e) {
                    MessageUtils.logDebugWithInfo("Failed to unregister command: " + command, e);
                }
                try {
                    Field knownCommandsField = commandMap.getClass().getDeclaredField("knownCommands");
                    knownCommandsField.setAccessible(true);
                    Map knownCommands = (Map)knownCommandsField.get(commandMap);
                    knownCommands.remove(com.getName());
                    for (String alias : com.getAliases()) {
                        knownCommands.remove(alias);
                    }
                }
                catch (Throwable e) {
                    MessageUtils.logDebugWithInfo("Failed to unregister command: " + command, e);
                }
            }
            CompletableFuture.runAsync(BasePlugin::syncCommands);
        }
        catch (Exception e) {
            MessageUtils.logWarningWithInfo("Failed to unregister commands: ", e);
        }
    }

    public static void syncCommands() {
        try {
            Class craftServerClass = Bukkit.getServer().getClass();
            try {
                Method syncCommandsMethod = craftServerClass.getDeclaredMethod("syncCommands", new Class[0]);
                syncCommandsMethod.setAccessible(true);
                syncCommandsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            }
            catch (NoSuchMethodException e) {
                MessageUtils.logDebugWithInfo("syncCommands method not found: ", e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                MessageUtils.logDebugWithInfo("Failed to invoke syncCommands method: ", e);
            }
        }
        catch (Exception e) {
            MessageUtils.logDebugWithInfo("An unknown error occurred while syncing commands: ", e);
        }
    }

    public static ConcurrentSkipListMap<String, Player> getPlayersByUUID() {
        ConcurrentSkipListMap<String, Player> map = new ConcurrentSkipListMap<String, Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            map.put(player.getUniqueId().toString(), player);
        }
        return map;
    }

    public static Command getBukkitCommand(String name) {
        return commandMap.getCommand(name);
    }

    @Override
    public java.util.logging.Logger getLoggerLogger() {
        return Bukkit.getLogger();
    }

    @Override
    public Logger getSLFLogger() {
        return null;
    }

    @Override
    public void teleportBackend(CosmicPlayer player, PlayerWorld world, WorldPosition position, PlayerRotation rotation) {
        Player bukkitPlayer = BasePlugin.getPlayer(player.getUuid());
        if (bukkitPlayer == null) {
            return;
        }
        Optional.ofNullable(Bukkit.getWorld((String)world.getIdentifier())).ifPresent(w -> {
            Location location = new Location(w, position.getX(), position.getY(), position.getZ(), rotation != null ? rotation.getYaw() : 0.0f, rotation != null ? rotation.getPitch() : 0.0f);
            host.plas.bou.scheduling.TaskManager.teleport((Entity)bukkitPlayer, (Location)location);
        });
    }

    @Override
    public ISingularityExtension.PlatformType getPlatformType() {
        return this.platformType;
    }

    @Override
    public ISingularityExtension.ServerType getServerType() {
        return this.serverType;
    }

    public CosmicResourcePack getResourcePack() {
        return this.resourcePack;
    }

    public void setResourcePack(CosmicResourcePack resourcePack) {
        this.resourcePack = resourcePack;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public static BasePlugin getInstance() {
        return instance;
    }

    public SLAPI<CommandSender, Player, BasePlugin, UserManager, Messenger> getSlapi() {
        return this.slapi;
    }

    public SLAPIB getSlapiB() {
        return this.slapiB;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public ConsoleHolder getConsoleHolder() {
        return this.consoleHolder;
    }

    public PlayerInterface getPlayerInterface() {
        return this.playerInterface;
    }

    public static PlayerChecker getPlayerChecker() {
        return playerChecker;
    }

    public static void setPlayerChecker(PlayerChecker playerChecker) {
        BasePlugin.playerChecker = playerChecker;
    }

    public static TaskScheduler getScheduler() {
        return scheduler;
    }

    public static void setScheduler(TaskScheduler scheduler) {
        BasePlugin.scheduler = scheduler;
    }

    public static PlatformListener.ProxyMessagingListener getProxyMessagingListener() {
        return proxyMessagingListener;
    }

    public static void setProxyMessagingListener(PlatformListener.ProxyMessagingListener proxyMessagingListener) {
        BasePlugin.proxyMessagingListener = proxyMessagingListener;
    }

    public static boolean isCommandsNeedToBeSynced() {
        return commandsNeedToBeSynced;
    }

    public static void setCommandsNeedToBeSynced(boolean commandsNeedToBeSynced) {
        BasePlugin.commandsNeedToBeSynced = commandsNeedToBeSynced;
    }

    public static CommandMap getCommandMap() {
        return commandMap;
    }

    public static void setCommandMap(CommandMap commandMap) {
        BasePlugin.commandMap = commandMap;
    }

    static {
        commandsNeedToBeSynced = false;
    }
}

