/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.listeners;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.profile.PlayerProfile;
import host.plas.bou.utils.ClassHelper;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.streamline.base.StreamlineSpigot;
import net.streamline.platform.Messenger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.CachedServerIcon;
import singularity.events.server.ping.PingReceivedEvent;
import singularity.objects.CosmicFavicon;
import singularity.objects.PingedResponse;

public class PaperListener
implements Listener {
    public PaperListener() {
        if (!ClassHelper.isPaper()) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)StreamlineSpigot.getInstance());
        StreamlineSpigot.getInstance().logInfo("PaperListener registered.");
    }

    @EventHandler
    public void onPing(PaperServerListPingEvent event) {
        CachedServerIcon icon;
        PingedResponse response;
        String hostName;
        try {
            hostName = event.getAddress().getHostName();
        }
        catch (Throwable e) {
            hostName = "";
        }
        PingedResponse.Protocol protocol = new PingedResponse.Protocol("latest", 1);
        ArrayList<PingedResponse.PlayerInfo> playerInfos = new ArrayList<PingedResponse.PlayerInfo>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            playerInfos.add(new PingedResponse.PlayerInfo(player.getName(), player.getUniqueId().toString()));
        }
        PingedResponse.Players players = new PingedResponse.Players(event.getMaxPlayers(), event.getNumPlayers(), playerInfos.toArray(new PingedResponse.PlayerInfo[0]));
        try {
            response = new PingedResponse(protocol, players, event.getMotd());
        }
        catch (Throwable e) {
            StreamlineSpigot.getInstance().logWarning("Failed to create PingedResponse: " + e.getMessage());
            StreamlineSpigot.getInstance().logWarning(e.getStackTrace());
            return;
        }
        PingReceivedEvent pingReceivedEvent = (PingReceivedEvent)new PingReceivedEvent(response, hostName).fire();
        if (pingReceivedEvent.isCancelled()) {
            return;
        }
        event.setMotd(Messenger.getInstance().codedString(pingReceivedEvent.getResponse().getDescription()));
        try {
            event.getPlayerSample().clear();
            ArrayList<PlayerProfile> playerSample = new ArrayList<PlayerProfile>();
            for (PingedResponse.PlayerInfo playerInfo : pingReceivedEvent.getResponse().getPlayers().getSample()) {
                try {
                    PlayerProfile profile = Bukkit.getServer().createProfile(playerInfo.getUniqueId());
                    profile.setName(Messenger.getInstance().codedString(playerInfo.getName()));
                    playerSample.add(profile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            event.getPlayerSample().addAll(playerSample);
        }
        catch (Throwable e) {
            StreamlineSpigot.getInstance().logWarning("Failed to set player sample: " + e.getMessage());
            StreamlineSpigot.getInstance().logWarning(e.getStackTrace());
        }
        event.setMaxPlayers(pingReceivedEvent.getResponse().getPlayers().getMax());
        event.setNumPlayers(pingReceivedEvent.getResponse().getPlayers().getOnline());
        CosmicFavicon favicon = pingReceivedEvent.getResponse().getFavicon();
        if (favicon != null) {
            try {
                icon = Bukkit.loadServerIcon((BufferedImage)favicon.getImage());
                event.setServerIcon(icon);
            }
            catch (Throwable e) {
                StreamlineSpigot.getInstance().logWarning("Failed to set server icon: " + e.getMessage());
                StreamlineSpigot.getInstance().logWarning(e.getStackTrace());
            }
        }
        try {
            icon = Bukkit.loadServerIcon((File)Paths.get(pingReceivedEvent.getResponse().getFaviconString(), new String[0]).toFile());
            event.setServerIcon(icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

