/*
 * Decompiled with CFR 0.152.
 */
package singularity.board.data.constructor;

import singularity.board.data.constructor.BoardDataConstructor;
import singularity.utils.MessageUtils;

public class BoardConstructable<C> {
    private C of;
    private BoardDataConstructor<?, C> constructor;

    public BoardConstructable(C of, BoardDataConstructor<?, C> constructor) {
        this.of = of;
        this.constructor = constructor;
    }

    public BoardConstructable<C> withConstructor(BoardDataConstructor<?, C> constructor) {
        this.constructor = constructor;
        return this;
    }

    public C construct() {
        try {
            return (C)this.constructor.apply(null);
        }
        catch (Exception e) {
            MessageUtils.logDebug(e);
            return null;
        }
    }

    public <D> C construct(D data) {
        try {
            return (C)this.constructor.apply(data);
        }
        catch (Exception e) {
            MessageUtils.logDebug(e);
            return null;
        }
    }

    public void setOf(C of) {
        this.of = of;
    }

    public void setConstructor(BoardDataConstructor<?, C> constructor) {
        this.constructor = constructor;
    }

    public C getOf() {
        return this.of;
    }

    public BoardDataConstructor<?, C> getConstructor() {
        return this.constructor;
    }
}

