/*
 * Decompiled with CFR 0.152.
 */
package singularity.command;

import java.util.Arrays;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import singularity.Singularity;
import singularity.command.CosmicCommand;
import singularity.command.ModuleCommand;
import singularity.interfaces.IProperCommand;

public class CommandHandler {
    private static ConcurrentSkipListMap<String, ModuleCommand> loadedModuleCommands = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, CosmicCommand> loadedStreamlineCommands = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, IProperCommand> properlyRegisteredCommands = new ConcurrentSkipListMap();

    private static void registerCommandRaw(CosmicCommand command) {
        if (CommandHandler.isProperCommandRegistered(command.getIdentifier())) {
            CommandHandler.unregisterCommandRaw(command.getIdentifier());
        }
        IProperCommand properCommand = Singularity.getInstance().getPlatform().createCommand(command);
        properCommand.register();
        CommandHandler.getProperlyRegisteredCommands().put(command.getIdentifier(), properCommand);
        CommandHandler.getLoadedStreamlineCommands().put(command.getBase(), command);
    }

    private static void unregisterCommandRaw(String identifier) {
        IProperCommand c = CommandHandler.getProperlyRegisteredCommands().get(identifier);
        if (c == null) {
            return;
        }
        c.unregister();
        CommandHandler.getProperlyRegisteredCommands().remove(identifier);
        CommandHandler.getLoadedStreamlineCommands().remove(identifier);
    }

    public static void registerStreamlineCommand(CosmicCommand command) {
        CommandHandler.registerCommandRaw(command);
    }

    public static void unregisterStreamlineCommand(CosmicCommand command) {
        CommandHandler.unregisterCommandRaw(command.getIdentifier());
    }

    public static void registerModuleCommand(ModuleCommand command) {
        CommandHandler.registerCommandRaw(command);
        CommandHandler.getLoadedModuleCommands().put(command.getBase(), command);
    }

    public static void unregisterModuleCommand(ModuleCommand command) {
        CommandHandler.unregisterCommandRaw(command.getIdentifier());
        CommandHandler.getLoadedModuleCommands().remove(command.getIdentifier());
    }

    public static IProperCommand getProperCommand(String identifier) {
        return CommandHandler.getProperlyRegisteredCommands().get(identifier);
    }

    public static CosmicCommand getStreamlineCommand(String identifier) {
        return CommandHandler.getLoadedStreamlineCommands().get(identifier);
    }

    public static ModuleCommand getModuleCommand(String identifier) {
        return CommandHandler.getLoadedModuleCommands().get(identifier);
    }

    public static boolean isProperCommandRegistered(String identifier) {
        return CommandHandler.getProperlyRegisteredCommands().containsKey(identifier);
    }

    public static boolean isStreamlineCommandRegistered(String identifier) {
        return CommandHandler.getLoadedStreamlineCommands().containsKey(identifier);
    }

    public static boolean isModuleCommandRegistered(String identifier) {
        return CommandHandler.getLoadedModuleCommands().containsKey(identifier);
    }

    public static void flushProperCommands() {
        CommandHandler.getProperlyRegisteredCommands().forEach((s2, iProperCommand) -> iProperCommand.unregister());
    }

    public static ConcurrentSkipListSet<String> getAllAliases() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        CommandHandler.getLoadedStreamlineCommands().forEach((s2, command) -> {
            r.addAll(Arrays.asList(command.getAliases()));
            r.add(command.getBase());
        });
        CommandHandler.getLoadedModuleCommands().forEach((s2, command) -> {
            r.addAll(Arrays.asList(command.getAliases()));
            r.add(command.getBase());
        });
        return r;
    }

    public static CosmicCommand getCommandByAlias(String alias) {
        CosmicCommand command = CommandHandler.getStreamlineCommand(alias);
        if (command != null) {
            return command;
        }
        AtomicReference<Object> commandRef = new AtomicReference<Object>(null);
        CommandHandler.getLoadedStreamlineCommands().forEach((s2, c) -> {
            if (commandRef.get() != null) {
                return;
            }
            for (String a : c.getAliases()) {
                if (!a.equalsIgnoreCase(alias)) continue;
                commandRef.set(c);
                break;
            }
        });
        if (commandRef.get() != null) {
            return commandRef.get();
        }
        CommandHandler.getLoadedModuleCommands().forEach((s2, c) -> {
            if (commandRef.get() != null) {
                return;
            }
            for (String a : c.getAliases()) {
                if (!a.equalsIgnoreCase(alias)) continue;
                commandRef.set(c);
                break;
            }
        });
        return commandRef.get();
    }

    public static ConcurrentSkipListMap<String, ModuleCommand> getLoadedModuleCommands() {
        return loadedModuleCommands;
    }

    public static void setLoadedModuleCommands(ConcurrentSkipListMap<String, ModuleCommand> loadedModuleCommands) {
        CommandHandler.loadedModuleCommands = loadedModuleCommands;
    }

    public static ConcurrentSkipListMap<String, CosmicCommand> getLoadedStreamlineCommands() {
        return loadedStreamlineCommands;
    }

    public static void setLoadedStreamlineCommands(ConcurrentSkipListMap<String, CosmicCommand> loadedStreamlineCommands) {
        CommandHandler.loadedStreamlineCommands = loadedStreamlineCommands;
    }

    public static ConcurrentSkipListMap<String, IProperCommand> getProperlyRegisteredCommands() {
        return properlyRegisteredCommands;
    }

    public static void setProperlyRegisteredCommands(ConcurrentSkipListMap<String, IProperCommand> properlyRegisteredCommands) {
        CommandHandler.properlyRegisteredCommands = properlyRegisteredCommands;
    }
}

