/*
 * Decompiled with CFR 0.152.
 */
package singularity.configs.given.whitelist;

import gg.drak.thebase.lib.leonhard.storage.Json;
import gg.drak.thebase.storage.documents.SimpleJsonDocument;
import java.util.Date;
import singularity.Singularity;
import singularity.configs.given.GivenConfigs;
import singularity.configs.given.whitelist.WhitelistEntry;
import singularity.utils.MessageUtils;

public class WhitelistConfig
extends SimpleJsonDocument {
    public WhitelistConfig() {
        super("whitelist.json", Singularity.getInstance().getDataFolder(), false);
    }

    public void setEnabled(boolean bool) {
        ((Json)this.getResource()).set("enabled", (Object)bool);
    }

    public boolean isEnabled() {
        this.reloadResource();
        return (Boolean)((Json)this.getResource()).getOrDefault("enabled", (Object)false);
    }

    public void setEnforced(boolean bool) {
        ((Json)this.getResource()).set("enforced", (Object)bool);
    }

    public boolean isEnforced() {
        this.reloadResource();
        return (Boolean)((Json)this.getResource()).getOrDefault("enforced", (Object)false);
    }

    public void addEntry(WhitelistEntry entry) {
        ((Json)this.getResource()).set("list." + entry.whitelistedAt().getTime() + ".uuid", (Object)entry.whitelistedUuid());
        ((Json)this.getResource()).set("list." + entry.whitelistedAt().getTime() + ".by", (Object)(entry.whitelistedBy() != null ? entry.whitelistedBy() : GivenConfigs.getMainConfig().getConsoleDiscriminator()));
    }

    public void removeEntry(WhitelistEntry entry) {
        ((Json)this.getResource()).remove("list." + entry.whitelistedAt().getTime() + ".uuid");
        ((Json)this.getResource()).remove("list." + entry.whitelistedAt().getTime() + ".by");
        ((Json)this.getResource()).remove("list." + entry.whitelistedAt().getTime());
    }

    public WhitelistEntry getEntry(String uuid) {
        this.reloadResource();
        for (String key : ((Json)this.getResource()).singleLayerKeySet("list")) {
            if (!((Json)this.getResource()).getString("list." + key + ".uuid").equals(uuid)) continue;
            try {
                Date whitelistedAt = new Date(Long.parseLong(key));
                String whitelistedUuid = ((Json)this.getResource()).getString("list." + key + ".uuid");
                String whitelistedBy = ((Json)this.getResource()).getString("list." + key + ".by");
                return new WhitelistEntry(whitelistedUuid, whitelistedAt, whitelistedBy);
            }
            catch (Exception e) {
                MessageUtils.logWarning("Error getting WhitelistEntry for UUID of '" + uuid + "':");
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEntryApplied(String uuid) {
        this.reloadResource();
        for (String key : ((Json)this.getResource()).singleLayerKeySet("list")) {
            if (!((Json)this.getResource()).getString("list." + key + ".uuid").equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public void onInit() {
    }

    public void onSave() {
    }
}

