/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.players.meta;

import gg.drak.thebase.lib.re2j.Matcher;
import gg.drak.thebase.utils.MatcherUtils;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.configs.given.GivenConfigs;
import singularity.data.IUuidable;
import singularity.data.console.CosmicSender;
import singularity.data.players.meta.MetaTag;

public class SenderMeta
implements IUuidable {
    private String uuid;
    private CosmicSender sender;
    private String nickname;
    private String prefix;
    private String suffix;
    private ConcurrentSkipListSet<MetaTag<?>> tags;

    public SenderMeta(CosmicSender sender) {
        this.uuid = sender.getUuid();
        this.sender = sender;
        this.nickname = GivenConfigs.getMainConfig().getDefaultMetaNickname();
        this.prefix = GivenConfigs.getMainConfig().getDefaultMetaPrefix();
        this.suffix = GivenConfigs.getMainConfig().getDefaultMetaSuffix();
        this.tags = new ConcurrentSkipListSet();
    }

    public ConcurrentSkipListMap<String, String> getTagsAsMap() {
        ConcurrentSkipListMap<String, String> map = new ConcurrentSkipListMap<String, String>();
        for (MetaTag<?> tag : this.tags) {
            map.put(tag.getIdentifier(), tag.getSerializedValue());
        }
        return map;
    }

    public String getTagsAsString() {
        StringBuilder builder = new StringBuilder();
        for (MetaTag<?> tag : this.tags) {
            builder.append("!!!").append(tag.getIdentifier()).append(":::").append(tag.getSerializedValue()).append(";;;");
        }
        return builder.toString();
    }

    public void setTagsFromString(String string) {
        Matcher matcher = MatcherUtils.matcherBuilder((String)"(!!!)(.*?)(:::)(.*?)(;;;)", (String)string);
        List matches = MatcherUtils.getGroups((Matcher)matcher, (int)5);
        for (String[] match : matches) {
            String identifier = match[1];
            String serializedValue = match[3];
            MetaTag tag = new MetaTag(identifier, serializedValue);
            this.tags.add(tag);
        }
    }

    public String getFull() {
        Object full = "";
        if (this.getNickname() != null && !this.getNickname().isEmpty() && !this.getNickname().isBlank()) {
            full = this.getNickname();
            if (this.getPrefix() != null && !this.getPrefix().isEmpty() && !this.getPrefix().isBlank()) {
                full = this.getPrefix() + (String)full;
            }
            if (this.getSuffix() != null && !this.getSuffix().isEmpty() && !this.getSuffix().isBlank()) {
                full = (String)full + this.getSuffix();
            }
        }
        return full;
    }

    public void addTag(String tag) {
        this.tags.add(new MetaTag(tag, tag));
    }

    public void removeTag(String tag) {
        this.tags.removeIf(metaTag -> metaTag.getIdentifier().equals(tag));
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public CosmicSender getSender() {
        return this.sender;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public ConcurrentSkipListSet<MetaTag<?>> getTags() {
        return this.tags;
    }

    @Override
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setSender(CosmicSender sender) {
        this.sender = sender;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setTags(ConcurrentSkipListSet<MetaTag<?>> tags) {
        this.tags = tags;
    }
}

