/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.uuid;

import gg.drak.thebase.lib.re2j.Matcher;
import gg.drak.thebase.utils.MatcherUtils;
import java.util.ArrayList;
import java.util.List;
import singularity.Singularity;
import singularity.data.IUuidable;
import singularity.data.uuid.UuidManager;

public class UuidInfo
implements IUuidable {
    private String uuid;
    private List<String> names;
    private List<String> ips;

    public UuidInfo(String uuid, List<String> names, List<String> ips) {
        this.uuid = uuid;
        this.names = names;
        this.ips = ips;
    }

    public UuidInfo(String uuid, String names, String ips) {
        this(uuid, UuidInfo.computeNames(names), UuidInfo.computeIps(ips));
    }

    public String computableNames() {
        StringBuilder builder = new StringBuilder();
        for (String name : this.names) {
            builder.append("!!!").append(name).append(":::");
        }
        return builder.toString();
    }

    public String computableIps() {
        StringBuilder builder = new StringBuilder();
        for (String ip : this.ips) {
            builder.append("!!!").append(ip).append(":::");
        }
        return builder.toString();
    }

    public void register() {
        UuidManager.registerUuid(this);
    }

    public void unregister() {
        UuidManager.unregisterUuid(this);
    }

    public void save() {
        Singularity.getMainDatabase().saveUuidInfo(this);
    }

    public void addName(String name) {
        if (!this.names.isEmpty() && this.names.get(this.names.size() - 1).equals(name)) {
            return;
        }
        this.names.add(name);
    }

    public void addIp(String ip) {
        if (!this.ips.isEmpty() && this.ips.get(this.ips.size() - 1).equals(ip)) {
            return;
        }
        this.ips.add(ip);
    }

    public void removeName(String name) {
        this.names.removeIf(n -> n.equals(name));
    }

    public void removeIp(String ip) {
        this.ips.removeIf(i -> i.equals(ip));
    }

    public List<String> getNamesCaseInsensitive() {
        ArrayList<String> r = new ArrayList<String>();
        for (String name : this.names) {
            r.add(name.toLowerCase());
        }
        return r;
    }

    public static List<String> computeNames(String names) {
        return UuidInfo.computeList(names);
    }

    public static List<String> computeIps(String ips) {
        return UuidInfo.computeList(ips);
    }

    public static List<String> computeList(String listString) {
        if (!UuidInfo.isComputable(listString)) {
            return new ArrayList<String>(List.of(listString));
        }
        Matcher matcher = MatcherUtils.matcherBuilder((String)"[!][!][!](.*?)[:][:][:]", (String)listString);
        List groups = MatcherUtils.getGroups((Matcher)matcher, (int)1);
        ArrayList<String> r = new ArrayList<String>();
        for (String[] group : groups) {
            String thing = group[0];
            if (!r.isEmpty() && ((String)r.get(r.size() - 1)).equals(thing)) continue;
            r.add(thing);
        }
        return r;
    }

    public static boolean isComputable(String listString) {
        return listString.startsWith("!!!") && listString.endsWith(":::");
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<String> getIps() {
        return this.ips;
    }

    @Override
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public void setIps(List<String> ips) {
        this.ips = ips;
    }
}

