/*
 * Decompiled with CFR 0.152.
 */
package singularity.holders;

import java.util.concurrent.ConcurrentSkipListSet;
import singularity.holders.HolderInit;
import singularity.holders.builtin.CosmicGeyserHolder;

public class HoldersHolder {
    public static String GEYSER_IDENTIFIER = "geyser";
    private static ConcurrentSkipListSet<HolderInit<?>> holders = new ConcurrentSkipListSet();

    public static void load(HolderInit<?> holderInit) {
        HoldersHolder.unload(holderInit);
        holders.add(holderInit);
    }

    public static void unload(HolderInit<?> holderInit) {
        HoldersHolder.getHolders().removeIf(h2 -> h2.getIdentifier().equals(holderInit.getIdentifier()));
    }

    public static HolderInit<?> get(String identifier) {
        return HoldersHolder.getHolders().stream().filter(h2 -> h2.getIdentifier().equals(identifier)).findFirst().orElse(null);
    }

    public static boolean has(String identifier) {
        return HoldersHolder.getHolders().stream().anyMatch(h2 -> h2.getIdentifier().equals(identifier));
    }

    public static CosmicGeyserHolder getGeyserHolder() {
        HolderInit<?> holderInit = HoldersHolder.get(GEYSER_IDENTIFIER);
        if (holderInit == null) {
            return null;
        }
        if (!(holderInit.getHolder() instanceof CosmicGeyserHolder)) {
            return null;
        }
        return (CosmicGeyserHolder)holderInit.getHolder();
    }

    public static ConcurrentSkipListSet<HolderInit<?>> getHolders() {
        return holders;
    }

    public static void setHolders(ConcurrentSkipListSet<HolderInit<?>> holders) {
        HoldersHolder.holders = holders;
    }
}

