/*
 * Decompiled with CFR 0.152.
 */
package singularity.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import singularity.events.server.ServerLogTextEvent;
import singularity.logging.LogIntent;

public class CosmicLogHandler
extends StreamHandler {
    public CosmicLogHandler() {
        super.setOutputStream(System.out);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        Level level = record.getLevel();
        LogIntent intent = null;
        switch (level.getName()) {
            case "FINE": {
                intent = LogIntent.DEBUG;
                break;
            }
            case "INFO": {
                intent = LogIntent.INFO;
                break;
            }
            case "WARNING": {
                intent = LogIntent.WARNING;
                break;
            }
            case "SEVERE": {
                intent = LogIntent.SEVERE;
                break;
            }
            default: {
                intent = LogIntent.OTHER;
            }
        }
        ServerLogTextEvent event = (ServerLogTextEvent)new ServerLogTextEvent(record.getMessage(), intent).fire();
        if (event.isCancelled()) {
            return;
        }
    }
}

