/*
 * Decompiled with CFR 0.152.
 */
package singularity.messages.proxied;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import gg.drak.thebase.utils.MathUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import singularity.Singularity;
import singularity.command.CommandMessageBuilder;
import singularity.messages.answered.ReturnableMessage;
import singularity.messages.builders.PlayerLocationMessageBuilder;
import singularity.messages.builders.ProxyParseMessageBuilder;
import singularity.messages.builders.ResourcePackMessageBuilder;
import singularity.messages.builders.ServerConnectMessageBuilder;
import singularity.messages.builders.ServerNameMessageBuilder;
import singularity.messages.proxied.ProxiedMessage;
import singularity.objects.CosmicResourcePack;
import singularity.objects.SingleSet;
import singularity.scheduler.BaseRunnable;

public class ProxiedMessageManager {
    private static PendingTicker pendingTicker;
    private static Cache<Date, ReturnableMessage> loadedReturnableMessaged;
    private static ConcurrentSkipListMap<Date, ProxiedMessage> pendingMessages;

    public static void init() {
        ProxiedMessageManager.setPendingTicker(new PendingTicker());
    }

    public static void loadReturnableMessage(ReturnableMessage returnableMessage) {
        ProxiedMessageManager.getLoadedReturnableMessaged().put(returnableMessage.getPayload().getGottenAt(), returnableMessage);
    }

    public static void unloadReturnableMessage(ReturnableMessage returnableMessage) {
        if (returnableMessage.getTimeoutTimer() != null) {
            returnableMessage.getTimeoutTimer().cancel();
        }
        ProxiedMessageManager.getLoadedReturnableMessaged().invalidate(returnableMessage.getPayload().getGottenAt());
    }

    public static void sendReturnable(ReturnableMessage returnableMessage) {
        ProxiedMessageManager.loadReturnableMessage(returnableMessage);
        returnableMessage.getPayload().send();
    }

    public static boolean killReturnable(ReturnableMessage returnableMessage) {
        if (!returnableMessage.isAnswered() && !MathUtils.isDateOlderThan((Date)returnableMessage.getPayload().getGottenAt(), (int)(ReturnableMessage.getTimeoutTicks() / 20), (ChronoUnit)ChronoUnit.SECONDS)) {
            return false;
        }
        ProxiedMessageManager.unloadReturnableMessage(returnableMessage);
        return true;
    }

    public static void onProxiedMessageReceived(ProxiedMessage proxiedMessage) {
        if (proxiedMessage.isReturnableLike()) {
            CompletableFuture.runAsync(() -> ProxiedMessageManager.getLoadedReturnableMessaged().asMap().forEach((date, returnableMessage) -> returnableMessage.tryAnswer(proxiedMessage)));
        }
        CompletableFuture.runAsync(() -> ProxiedMessageManager.handle(proxiedMessage));
    }

    public static void handle(ProxiedMessage proxiedMessage) {
        if (proxiedMessage.getMainChannel().equals(Singularity.getApiChannel())) {
            if (proxiedMessage.getSubChannel().equals(ResourcePackMessageBuilder.getSubChannel())) {
                SingleSet<String, CosmicResourcePack> set2 = ResourcePackMessageBuilder.unbuild(proxiedMessage);
                CosmicResourcePack resourcePack = set2.getValue();
                Singularity.getInstance().getPlatform().sendResourcePack(resourcePack, set2.getKey());
                return;
            }
            if (proxiedMessage.getSubChannel().equals(CommandMessageBuilder.getSubChannel())) {
                CommandMessageBuilder.handle(proxiedMessage);
                return;
            }
            if (proxiedMessage.getSubChannel().equals(ProxyParseMessageBuilder.getSubChannel())) {
                ProxyParseMessageBuilder.handle(proxiedMessage);
                return;
            }
            if (proxiedMessage.getSubChannel().equals(PlayerLocationMessageBuilder.getSubChannel())) {
                PlayerLocationMessageBuilder.handle(proxiedMessage);
                return;
            }
            if (proxiedMessage.getSubChannel().equals(ServerConnectMessageBuilder.getSubChannel())) {
                ServerConnectMessageBuilder.handle(proxiedMessage);
                return;
            }
            if (proxiedMessage.getSubChannel().equals(ServerNameMessageBuilder.getSubChannel())) {
                ServerNameMessageBuilder.handle(proxiedMessage);
                return;
            }
        }
    }

    public static void pendMessage(ProxiedMessage proxiedMessage) {
        ProxiedMessageManager.getPendingMessages().put(proxiedMessage.getGottenAt(), proxiedMessage);
    }

    public static void unpendMessage(ProxiedMessage proxiedMessage) {
        ProxiedMessageManager.getPendingMessages().remove(proxiedMessage.getGottenAt());
    }

    public static void tickPendingMessages() {
        ProxiedMessageManager.getPendingMessages().forEach((date, proxiedMessage) -> {
            Singularity.getInstance().getProxyMessenger().sendMessage((ProxiedMessage)proxiedMessage);
            if (MathUtils.isDateOlderThan((Date)date, (int)10, (ChronoUnit)ChronoUnit.MINUTES)) {
                ProxiedMessageManager.unpendMessage(proxiedMessage);
            }
        });
    }

    public static PendingTicker getPendingTicker() {
        return pendingTicker;
    }

    public static void setPendingTicker(PendingTicker pendingTicker) {
        ProxiedMessageManager.pendingTicker = pendingTicker;
    }

    public static Cache<Date, ReturnableMessage> getLoadedReturnableMessaged() {
        return loadedReturnableMessaged;
    }

    public static void setLoadedReturnableMessaged(Cache<Date, ReturnableMessage> loadedReturnableMessaged) {
        ProxiedMessageManager.loadedReturnableMessaged = loadedReturnableMessaged;
    }

    public static ConcurrentSkipListMap<Date, ProxiedMessage> getPendingMessages() {
        return pendingMessages;
    }

    public static void setPendingMessages(ConcurrentSkipListMap<Date, ProxiedMessage> pendingMessages) {
        ProxiedMessageManager.pendingMessages = pendingMessages;
    }

    static {
        loadedReturnableMessaged = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(2L)).build();
        pendingMessages = new ConcurrentSkipListMap();
    }

    public static class PendingTicker
    extends BaseRunnable {
        public PendingTicker() {
            super(40L, 40L);
        }

        @Override
        public void run() {
            ProxiedMessageManager.tickPendingMessages();
        }
    }
}

