/*
 * Decompiled with CFR 0.152.
 */
package singularity.redis;

import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.redis.RedisListener;

public class RedisHandler {
    private static ConcurrentSkipListSet<RedisListener> listeners = new ConcurrentSkipListSet();

    public static void load(RedisListener listener) {
        RedisHandler.unload(listener);
        listeners.add(listener);
    }

    public static void unload(RedisListener listener) {
        RedisHandler.unload(listener.getIdentifier());
    }

    public static void unload(String identifier) {
        listeners.removeIf(listener -> listener.getIdentifier().equals(identifier));
    }

    public static Optional<RedisListener> get(String identifier) {
        return listeners.stream().filter(listener -> listener.getIdentifier().equals(identifier)).findFirst();
    }

    public static boolean isLoaded(String identifier) {
        return listeners.stream().anyMatch(listener -> listener.getIdentifier().equals(identifier));
    }

    public static boolean isLoaded(RedisListener listener) {
        return RedisHandler.isLoaded(listener.getIdentifier());
    }

    public static RedisListener getOrNull(String identifier) {
        return RedisHandler.get(identifier).orElse(null);
    }

    public static ConcurrentSkipListSet<RedisListener> getListeners() {
        return listeners;
    }

    public static void setListeners(ConcurrentSkipListSet<RedisListener> listeners) {
        RedisHandler.listeners = listeners;
    }
}

