/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage;

import de.leonhard.storage.internal.FileData;
import de.leonhard.storage.internal.FileType;
import de.leonhard.storage.internal.FlatFile;
import de.leonhard.storage.internal.editor.yaml.SimpleYamlReader;
import de.leonhard.storage.internal.editor.yaml.SimpleYamlWriter;
import de.leonhard.storage.internal.editor.yaml.YamlEditor;
import de.leonhard.storage.internal.editor.yaml.YamlParser;
import de.leonhard.storage.internal.provider.SimplixProviders;
import de.leonhard.storage.internal.settings.ConfigSettings;
import de.leonhard.storage.internal.settings.DataType;
import de.leonhard.storage.internal.settings.ErrorHandler;
import de.leonhard.storage.internal.settings.ReloadSettings;
import de.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import de.leonhard.storage.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;

public class Yaml
extends FlatFile {
    protected final InputStream inputStream;
    protected final YamlEditor yamlEditor;
    protected final YamlParser parser;
    private ConfigSettings configSettings = ConfigSettings.SKIP_COMMENTS;
    private boolean exists = false;

    public Yaml(@NonNull Yaml yaml) {
        super(yaml.getFile(), yaml.pathSeparator());
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        this.fileData = yaml.getFileData();
        this.yamlEditor = yaml.getYamlEditor();
        this.parser = yaml.getParser();
        this.configSettings = yaml.getConfigSettings();
        this.inputStream = yaml.getInputStream().orElse(null);
        this.pathPrefix = yaml.getPathPrefixArray();
        this.reloadConsumer = yaml.getReloadConsumer();
        this.exists = true;
    }

    public Yaml(String name, @Nullable String path) {
        this(name, path, (InputStream)null, (ReloadSettings)null, (ConfigSettings)null, (DataType)null);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream) {
        this(name, path, inputStream, null, null, null);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable ConfigSettings configSettings, @Nullable DataType dataType) {
        this(name, path, inputStream, reloadSettings, configSettings, dataType, null);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable ConfigSettings configSettings, @Nullable DataType dataType, @Nullable Consumer<FlatFile> reloadConsumer) {
        this(name, path, inputStream, reloadSettings, configSettings, dataType, null, reloadConsumer);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable ConfigSettings configSettings, @Nullable DataType dataType, @Nullable String pathPattern, @Nullable Consumer<FlatFile> reloadConsumer) {
        this(name, path, inputStream, reloadSettings, null, configSettings, dataType, pathPattern, reloadConsumer);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable ErrorHandler errorHandler, @Nullable ConfigSettings configSettings, @Nullable DataType dataType, @Nullable String pathPattern, @Nullable Consumer<FlatFile> reloadConsumer) {
        super(name, path, FileType.YAML, pathPattern, reloadConsumer);
        this.inputStream = inputStream;
        if (configSettings != null) {
            this.configSettings = configSettings;
        }
        if (this.create() && inputStream != null) {
            this.exists = FileUtils.writeToFile(this.file, inputStream, this.configSettings == ConfigSettings.FIRST_TIME);
        }
        this.yamlEditor = new YamlEditor(this.file);
        this.parser = new YamlParser(this.yamlEditor);
        if (reloadSettings != null) {
            this.reloadSettings = reloadSettings;
        }
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
        this.dataType = dataType != null ? dataType : DataType.forConfigSetting(configSettings);
        this.forceReload();
    }

    public Yaml(File file) {
        this(file.getName(), FileUtils.getParentDirPath(file));
    }

    public Yaml addDefaultsFromInputStream() {
        return this.addDefaultsFromInputStream(false);
    }

    public Yaml addDefaultsFromInputStream(boolean force) {
        return this.addDefaultsFromInputStream(this.getInputStream().orElse(null), force);
    }

    public Yaml addDefaultsFromInputStream(@Nullable InputStream inputStream) {
        return this.addDefaultsFromInputStream(inputStream, false);
    }

    public Yaml addDefaultsFromInputStream(@Nullable InputStream inputStream, boolean force) {
        this.reloadIfNeeded();
        if (inputStream == null) {
            return this;
        }
        if (!force && this.configSettings == ConfigSettings.FIRST_TIME && this.exists) {
            return this;
        }
        if (this.shouldSetEmpty()) {
            SimplixProviders.logger().sendWarning("Tried to write values but is lock by an error!");
            return this;
        }
        try {
            Map<String, Object> data = new SimpleYamlReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).readToMap();
            FileData newData = new FileData(data, DataType.UNSORTED);
            for (String key : newData.keySet()) {
                if (this.fileData.containsKey(key)) continue;
                this.fileData.insert(key, newData.get(key));
            }
            this.write();
        }
        catch (Exception ex) {
            SimplixProviders.logger().printStackTrace(ex);
        }
        return this;
    }

    @Override
    protected Map<String, Object> readToMap() throws IOException {
        SimpleYamlReader reader = new SimpleYamlReader(this.getFile());
        try {
            Map<String, Object> map = reader.readToMap();
            return map;
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    @Override
    protected void write(FileData data) throws IOException {
        if (this.configSettings.isSorted()) {
            List<String> unEdited = this.yamlEditor.read();
            this.write0(this.fileData);
            this.yamlEditor.write(this.parser.parseLines(unEdited, this.yamlEditor.readKeys()));
        } else if (this.configSettings.isUnsorted()) {
            this.write0(this.fileData);
        }
    }

    private void write0(FileData fileData) throws IOException {
        SimpleYamlWriter writer = new SimpleYamlWriter(this.file);
        try {
            writer.write(fileData.toMap());
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                writer.close();
            }
        }
    }

    public final List<String> getHeader() {
        return this.yamlEditor.readHeader();
    }

    public final void setHeader(List<String> header) {
        this.yamlEditor.setHeader(header);
    }

    public final void setHeader(String ... header) {
        this.setHeader(Arrays.asList(header));
    }

    public final void addHeader(List<String> toAdd) {
        this.yamlEditor.addHeader(toAdd);
    }

    public final void addHeader(String ... header) {
        this.addHeader(Arrays.asList(header));
    }

    public final void framedHeader(String ... header) {
        ArrayList<String> stringList = new ArrayList<String>();
        String border = "# +----------------------------------------------------+ #";
        stringList.add(border);
        for (String line : header) {
            StringBuilder builder = new StringBuilder();
            if (line.length() > 50) continue;
            int length = (50 - line.length()) / 2;
            StringBuilder finalLine = new StringBuilder(line);
            for (int i2 = 0; i2 < length; ++i2) {
                finalLine.append(" ");
                finalLine.reverse();
                finalLine.append(" ");
                finalLine.reverse();
            }
            if (line.length() % 2 != 0) {
                finalLine.append(" ");
            }
            builder.append("# < ").append((CharSequence)finalLine).append(" > #");
            stringList.add(builder.toString());
        }
        stringList.add(border);
        this.setHeader(stringList);
    }

    public final Optional<InputStream> getInputStream() {
        return Optional.ofNullable(this.inputStream);
    }

    @Generated
    public YamlEditor getYamlEditor() {
        return this.yamlEditor;
    }

    @Generated
    public YamlParser getParser() {
        return this.parser;
    }

    @Generated
    public ConfigSettings getConfigSettings() {
        return this.configSettings;
    }

    @Generated
    public boolean isExists() {
        return this.exists;
    }

    @Generated
    public void setConfigSettings(ConfigSettings configSettings) {
        this.configSettings = configSettings;
    }
}

