/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.leonhard.storage;

import gg.drak.thebase.lib.leonhard.storage.Config;
import gg.drak.thebase.lib.leonhard.storage.Json;
import gg.drak.thebase.lib.leonhard.storage.Toml;
import gg.drak.thebase.lib.leonhard.storage.Yaml;
import gg.drak.thebase.lib.leonhard.storage.internal.FlatFile;
import gg.drak.thebase.lib.leonhard.storage.internal.provider.InputStreamProvider;
import gg.drak.thebase.lib.leonhard.storage.internal.provider.SimplixProviders;
import gg.drak.thebase.lib.leonhard.storage.internal.settings.ConfigSettings;
import gg.drak.thebase.lib.leonhard.storage.internal.settings.DataType;
import gg.drak.thebase.lib.leonhard.storage.internal.settings.ErrorHandler;
import gg.drak.thebase.lib.leonhard.storage.internal.settings.ReloadSettings;
import gg.drak.thebase.lib.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import gg.drak.thebase.lib.leonhard.storage.util.FileUtils;
import gg.drak.thebase.lib.leonhard.storage.util.Valid;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Consumer;
import lombok.NonNull;

public final class SimplixBuilder {
    private final InputStreamProvider inputStreamProvider;
    private final String path;
    private String name;
    private InputStream inputStream;
    private ReloadSettings reloadSettings;
    private ErrorHandler errorHandler;
    private ConfigSettings configSettings;
    private DataType dataType;
    private String pathPattern = null;
    @Nullable
    private Consumer<FlatFile> reloadConsumer = null;

    private SimplixBuilder(String name, String path, InputStreamProvider inputStreamProvider) {
        this.name = name;
        this.path = path;
        this.inputStreamProvider = inputStreamProvider;
    }

    public static SimplixBuilder fromPath(@NonNull String name, @NonNull String path) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new SimplixBuilder(name, path, SimplixProviders.inputStreamProvider());
    }

    public static SimplixBuilder fromPath(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return SimplixBuilder.fromFile(path.toFile());
    }

    public static SimplixBuilder fromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(!file.isDirectory(), "File mustn't be a directory.", "Please use from Directory to use a directory", "This is due to Java-Internals");
        return new SimplixBuilder(FileUtils.replaceExtensions(file.getName()), FileUtils.getParentDirPath(file), SimplixProviders.inputStreamProvider());
    }

    public static SimplixBuilder fromDirectory(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(!file.getName().contains("."), "File-Name mustn't contain '.'");
        if (!file.exists()) {
            file.mkdirs();
        }
        return new SimplixBuilder(file.getName(), file.getAbsolutePath(), SimplixProviders.inputStreamProvider());
    }

    public SimplixBuilder reloadCallback(@Nullable Consumer<FlatFile> reloadConsumer) {
        this.reloadConsumer = reloadConsumer;
        return this;
    }

    public SimplixBuilder addInputStreamFromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.inputStream = FileUtils.createInputStream(file);
        return this;
    }

    public SimplixBuilder addInputStreamFromResource(@NonNull String resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.inputStream = this.inputStreamProvider.createInputStreamFromInnerResource(resource);
        Valid.notNull(this.inputStream, "InputStream is null.", "No inbuilt resource '" + resource + "' found: ");
        return this;
    }

    public SimplixBuilder setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        return this;
    }

    public SimplixBuilder addInputStream(@Nullable InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public SimplixBuilder setErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public SimplixBuilder setConfigSettings(@NonNull ConfigSettings configSettings) {
        if (configSettings == null) {
            throw new NullPointerException("configSettings is marked non-null but is null");
        }
        this.configSettings = configSettings;
        return this;
    }

    public SimplixBuilder setReloadSettings(@NonNull ReloadSettings reloadSettings) {
        if (reloadSettings == null) {
            throw new NullPointerException("reloadSettings is marked non-null but is null");
        }
        this.reloadSettings = reloadSettings;
        return this;
    }

    public SimplixBuilder setDataType(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        this.dataType = dataType;
        return this;
    }

    public SimplixBuilder setPathPattern(@Nullable String pathPattern) {
        this.pathPattern = pathPattern;
        return this;
    }

    public SimplixBuilder setDotPattern() {
        this.pathPattern = ".";
        return this;
    }

    public SimplixBuilder setBracketPattern() {
        this.pathPattern = "{}";
        return this;
    }

    public Config createConfig() {
        return new Config(this.name, this.path, this.inputStream, this.reloadSettings, this.configSettings, this.dataType, this.pathPattern, this.reloadConsumer);
    }

    public Yaml createYaml() {
        return new Yaml(this.name, this.path, this.inputStream, this.reloadSettings, this.errorHandler, this.configSettings, this.dataType, this.pathPattern, this.reloadConsumer);
    }

    public Toml createToml() {
        return new Toml(this.name, this.path, this.inputStream, this.reloadSettings, this.errorHandler, this.pathPattern, this.reloadConsumer);
    }

    public Json createJson() {
        return new Json(this.name, this.path, this.inputStream, this.reloadSettings, this.errorHandler, this.pathPattern, this.reloadConsumer);
    }
}

