/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.leonhard.storage.util;

import gg.drak.thebase.lib.leonhard.storage.internal.provider.SimplixProviders;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class LagCatcher {
    private static final Map<String, Long> startTimes = new HashMap<String, Long>();
    private static final Map<String, Long> stopTimes = new HashMap<String, Long>();

    public static void start(String name) {
        if (startTimes.containsKey(name)) {
            throw new IllegalStateException("Test is already running for '" + name + "'");
        }
        long nanoTime = System.nanoTime();
        startTimes.put(name, nanoTime);
    }

    public static void stop(String name) {
        if (stopTimes.containsKey(name)) {
            throw new IllegalStateException("No test running for '" + name + "'");
        }
        stopTimes.put(name, System.nanoTime());
    }

    private static void show(String name) {
        if (!startTimes.containsKey(name) || !stopTimes.containsKey(name)) {
            throw new IllegalStateException("No results found for '" + name + "'");
        }
        Long value = startTimes.get(name);
        if (value == null) {
            return;
        }
        Long value2 = stopTimes.get(name);
        if (value2 != null) {
            long took = value2 - value;
            SimplixProviders.logger().printMessage((Object)("Test '" + name + "' took " + TimeUnit.NANOSECONDS.toMicros(took) + " micro-seconds. That's " + TimeUnit.NANOSECONDS.toMillis(took) + " ms."));
            stopTimes.remove(name);
            startTimes.remove(name);
        }
    }

    public static void stopAndShow(String name) {
        LagCatcher.stop(name);
        LagCatcher.show(name);
    }

    public static void runMultipleTimes(int cycles, Runnable runnable) {
        long nanosTook = 0L;
        for (int i2 = 0; i2 < cycles; ++i2) {
            long nanoTime = System.nanoTime();
            runnable.run();
            nanosTook += System.nanoTime() - nanoTime;
        }
        SimplixProviders.logger().printMessage((Object)("Average time: " + TimeUnit.NANOSECONDS.toMicros(nanosTook / (long)cycles) + " micros - " + TimeUnit.NANOSECONDS.toMillis(nanosTook / (long)cycles) + " ms."));
        SimplixProviders.logger().printMessage((Object)("Test took: " + TimeUnit.NANOSECONDS.toMicros(nanosTook) + " micros - " + TimeUnit.NANOSECONDS.toMillis(nanosTook) + " ms"));
    }

    @Generated
    private LagCatcher() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

