/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.storage;

import gg.drak.thebase.lib.leonhard.storage.Config;
import gg.drak.thebase.lib.leonhard.storage.Json;
import gg.drak.thebase.lib.leonhard.storage.SimplixBuilder;
import gg.drak.thebase.lib.leonhard.storage.Toml;
import gg.drak.thebase.lib.leonhard.storage.Yaml;
import gg.drak.thebase.lib.leonhard.storage.internal.FlatFile;
import gg.drak.thebase.lib.leonhard.storage.internal.settings.ConfigSettings;
import gg.drak.thebase.lib.leonhard.storage.internal.settings.ReloadSettings;
import gg.drak.thebase.objects.handling.derived.IModifierEventable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import lombok.Generated;

public class StorageUtils {
    private static final File environmentFolder = new File(System.getProperty("user.dir"));

    public static File initializeModifierEventableFolder(IModifierEventable eventable) {
        File parentDir = StorageUtils.getEnvironmentFolder();
        if (eventable.isMod()) {
            parentDir = new File(StorageUtils.getEnvironmentFolder(), "mods" + File.separator);
        }
        if (eventable.isPlugin()) {
            parentDir = new File(StorageUtils.getEnvironmentFolder(), "plugins" + File.separator);
        }
        return new File(parentDir, eventable.getIdentifier() + File.separator);
    }

    public static boolean copy(File updateFile, File file) {
        try {
            Files.copy(updateFile.toPath(), file.toPath(), new CopyOption[0]);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static SupportedStorageType getStorageTypeFromLeonhard(Class<? extends FlatFile> leonhard) {
        return StorageUtils.getStorageType(leonhard);
    }

    public static SupportedStorageType getStorageType(Class<?> clazz) {
        if (clazz.equals(Yaml.class)) {
            return SupportedStorageType.YAML;
        }
        if (clazz.equals(Config.class)) {
            return SupportedStorageType.YAML;
        }
        if (clazz.equals(Json.class)) {
            return SupportedStorageType.JSON;
        }
        if (clazz.equals(Toml.class)) {
            return SupportedStorageType.TOML;
        }
        return null;
    }

    public static String parseDotsMongo(String key) {
        return key.replace("-", "").replace(".", "_");
    }

    public static void ensureFileFromSelf(ClassLoader loader, File parentDirectory, File toEnsure, String fileName) {
        if (!toEnsure.exists()) {
            try {
                parentDirectory.mkdirs();
                try (InputStream in = loader.getResourceAsStream(fileName);){
                    assert (in != null);
                    Files.copy(in, toEnsure.toPath(), new CopyOption[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void ensureFileFromSelf(ClassLoader loader, File parentDirectory, File toEnsure) {
        StorageUtils.ensureFileFromSelf(loader, parentDirectory, toEnsure, toEnsure.getName());
    }

    public static void ensureFileNoDefault(File parentDirectory, File toEnsure) {
        if (!toEnsure.exists()) {
            try {
                parentDirectory.mkdirs();
                toEnsure.createNewFile();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void ensureFileExists(String path) {
        File file = new File(path);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static SimplixBuilder fromFile(File file) {
        return SimplixBuilder.fromFile(file).setReloadSettings(StorageUtils.getDefaultReloadSettings()).setConfigSettings(StorageUtils.getDefaultConfigSettings());
    }

    public static ReloadSettings getDefaultReloadSettings() {
        return ReloadSettings.INTELLIGENT;
    }

    public static ConfigSettings getDefaultConfigSettings() {
        return ConfigSettings.PRESERVE_COMMENTS;
    }

    @Generated
    public static File getEnvironmentFolder() {
        return environmentFolder;
    }

    public static enum SupportedSQLType {
        MYSQL,
        SQLITE;

    }

    public static enum SupportedDatabaseType {
        MONGO,
        MYSQL,
        SQLITE;

    }

    public static enum SupportedStorageType {
        YAML,
        JSON,
        TOML,
        MONGO,
        MYSQL,
        SQLITE;

    }
}

