/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.storage.resources;

import gg.drak.thebase.objects.Classifiable;
import gg.drak.thebase.storage.StorageUtils;
import gg.drak.thebase.utils.MathUtils;
import gg.drak.thebase.utils.StringUtils;
import java.io.InputStream;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public abstract class StorageResource<T>
implements Comparable<StorageResource<?>>,
Classifiable<T> {
    private final Date initializeDate = new Date();
    private StorageUtils.SupportedStorageType type;
    private Class<T> resourceType;
    private String discriminatorKey;
    private Object discriminator;
    private int hangingMillis;
    private Date lastReload;
    private ConcurrentSkipListMap<String, Object> map;

    public StorageResource(Class<T> resourceType, String discriminatorKey, Object discriminator) {
        this.resourceType = resourceType;
        this.discriminatorKey = discriminatorKey;
        this.discriminator = discriminator;
        this.type = StorageUtils.getStorageType(resourceType);
        this.hangingMillis = 5000;
        this.map = new ConcurrentSkipListMap();
    }

    public void reloadResource() {
        this.reloadResource(false);
    }

    public abstract <O> O get(String var1, Class<O> var2);

    public void reloadResource(boolean force) {
        if (!force && this.lastReload != null && !MathUtils.isDateOlderThan(this.lastReload, this.hangingMillis, ChronoUnit.MILLIS)) {
            return;
        }
        this.continueReloadResource();
        this.lastReload = new Date();
    }

    public abstract void continueReloadResource();

    public abstract <V> void write(String var1, V var2);

    public abstract <O> O getOrSetDefault(String var1, O var2);

    public void sync() {
        this.push();
        this.reloadResource();
    }

    public void sync(boolean force) {
        this.push();
        this.reloadResource(force);
    }

    public abstract void push();

    public abstract void delete();

    public abstract boolean exists();

    public ConcurrentSkipListSet<String> singleLayerKeySet() {
        return this.singleLayerKeySet("");
    }

    public ConcurrentSkipListSet<String> singleLayerKeySet(String section) {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        this.map.keySet().forEach(a -> {
            if (a.startsWith(section)) {
                int start = a.substring(section.length()).lastIndexOf(".") + 1;
                String k = a.substring(start);
                int end = k.indexOf(".");
                if (end == -1) {
                    end = k.length();
                }
                k = k.substring(0, end);
                r.add(k);
            }
        });
        return r;
    }

    public abstract <V> void updateSingle(String var1, V var2);

    public abstract <V> void updateMultiple(ConcurrentSkipListMap<String, V> var1);

    public boolean isEmpty() {
        this.sync(true);
        return this.getMap().isEmpty();
    }

    public InputStream getResourceAsStream(String filename) {
        return this.getClass().getClassLoader().getResourceAsStream(filename);
    }

    @Override
    public int compareTo(@NotNull StorageResource<?> other) {
        return Long.compare(this.getInitializeDate().getTime(), other.getInitializeDate().getTime());
    }

    @Override
    public Class<T> getClassifier() {
        return this.getResourceType();
    }

    public String getDiscriminatorAsString() {
        return "" + this.discriminator;
    }

    public String getStringFromStringList(List<String> list, String prefix, String suffix) {
        return prefix + StringUtils.listToString(list, ",") + suffix;
    }

    public String getStringFromStringList(ConcurrentSkipListSet<String> list, String prefix, String suffix) {
        return this.getStringFromStringList(new ArrayList<String>(list), prefix, suffix);
    }

    @Generated
    public Date getInitializeDate() {
        return this.initializeDate;
    }

    @Generated
    public StorageUtils.SupportedStorageType getType() {
        return this.type;
    }

    @Generated
    public Class<T> getResourceType() {
        return this.resourceType;
    }

    @Generated
    public String getDiscriminatorKey() {
        return this.discriminatorKey;
    }

    @Generated
    public Object getDiscriminator() {
        return this.discriminator;
    }

    @Generated
    public int getHangingMillis() {
        return this.hangingMillis;
    }

    @Generated
    public Date getLastReload() {
        return this.lastReload;
    }

    @Generated
    public ConcurrentSkipListMap<String, Object> getMap() {
        return this.map;
    }

    @Generated
    public void setType(StorageUtils.SupportedStorageType type) {
        this.type = type;
    }

    @Generated
    public void setResourceType(Class<T> resourceType) {
        this.resourceType = resourceType;
    }

    @Generated
    public void setDiscriminatorKey(String discriminatorKey) {
        this.discriminatorKey = discriminatorKey;
    }

    @Generated
    public void setDiscriminator(Object discriminator) {
        this.discriminator = discriminator;
    }

    @Generated
    public void setHangingMillis(int hangingMillis) {
        this.hangingMillis = hangingMillis;
    }

    @Generated
    public void setLastReload(Date lastReload) {
        this.lastReload = lastReload;
    }

    @Generated
    public void setMap(ConcurrentSkipListMap<String, Object> map) {
        this.map = map;
    }
}

