/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;

public class StringUtils {
    public static String color(String s2) {
        return s2.replace("&", "\u00a7");
    }

    public static String uncolor(String s2) {
        return s2.replace("\u00a7", "&");
    }

    public static String capitalize(String s2) {
        return s2.substring(0, 1).toUpperCase() + s2.substring(1);
    }

    public static String uncapitalize(String s2) {
        return s2.substring(0, 1).toLowerCase() + s2.substring(1);
    }

    public static String capitalizeAll(String s2) {
        String[] split = s2.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String s1 : split) {
            sb.append(StringUtils.capitalize(s1)).append(" ");
        }
        return sb.toString().trim();
    }

    public static String uncapitalizeAll(String s2) {
        String[] split = s2.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String s1 : split) {
            sb.append(StringUtils.uncapitalize(s1)).append(" ");
        }
        return sb.toString().trim();
    }

    public static <T> List<String> stringify(List<T> list) {
        ArrayList<String> strings = new ArrayList<String>();
        for (T t2 : list) {
            strings.add(t2.toString());
        }
        return strings;
    }

    public static <T> T[] newEmptyArray() {
        return new Object[0];
    }

    public static <T> T[] argsMinus(T[] array, int ... indexes) {
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        for (int index : indexes) {
            indexesList.add(index);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (indexesList.contains(i2)) continue;
            list.add(array[i2]);
        }
        return list.toArray(StringUtils.newEmptyArray());
    }

    public static String[] argsMinus(String[] array, int ... indexes) {
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        for (int index : indexes) {
            indexesList.add(index);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (indexesList.contains(i2)) continue;
            list.add(array[i2]);
        }
        return list.toArray(new String[0]);
    }

    public static <T> String argsToString(T[] args) {
        StringBuilder sb = new StringBuilder();
        for (T arg : args) {
            sb.append(arg).append(" ");
        }
        return sb.toString().trim();
    }

    public static String argsToString(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg).append(" ");
        }
        return sb.toString().trim();
    }

    public static <T> String argsToStringMinus(T[] args, int ... indexes) {
        T[] argsMinus = StringUtils.argsMinus(args, indexes);
        return StringUtils.argsToString(argsMinus);
    }

    public static String argsToStringMinus(String[] args, int ... indexes) {
        String[] argsMinus = StringUtils.argsMinus(args, indexes);
        return StringUtils.argsToString(argsMinus);
    }

    public static <T> T[] argsWithoutNulls(T[] args) {
        ArrayList<T> list = new ArrayList<T>();
        for (T arg : args) {
            if (arg == null) continue;
            list.add(arg);
        }
        return list.toArray(args);
    }

    public static String[] argsWithoutEmptyOrNull(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (String arg : args) {
            if (arg == null || arg.isEmpty()) continue;
            list.add(arg);
        }
        return list.toArray(args);
    }

    public static String[] argsWithoutEmptyOrNullMinus(String[] args, int ... indexes) {
        String[] argsMinus = StringUtils.argsMinus(args, indexes);
        return StringUtils.argsWithoutEmptyOrNull(argsMinus);
    }

    public static String removeNonIdentifierSafeChars(String string) {
        return string.replaceAll("[^a-zA-Z0-9_\\-+]", "");
    }

    public static ConcurrentSkipListSet<String> getAsCompletion(String toComplete, String ... listOfPossibilities) {
        ConcurrentSkipListSet<String> strings = new ConcurrentSkipListSet<String>();
        if (toComplete == null) {
            return new ConcurrentSkipListSet<String>(List.of(listOfPossibilities));
        }
        if (toComplete.isEmpty() || toComplete.isBlank()) {
            return new ConcurrentSkipListSet<String>(List.of(listOfPossibilities));
        }
        for (String possibility : listOfPossibilities) {
            if (!possibility.toLowerCase().startsWith(toComplete.toLowerCase())) continue;
            strings.add(possibility);
        }
        return strings;
    }

    public static ConcurrentSkipListSet<String> getAsCompletion(String toComplete, Collection<String> listOfPossibilities) {
        return StringUtils.getAsCompletion(toComplete, listOfPossibilities.toArray(new String[0]));
    }

    public static List<String> getAsCompletionList(String toComplete, String ... listOfPossibilities) {
        return new ArrayList<String>(StringUtils.getAsCompletion(toComplete, listOfPossibilities));
    }

    public static List<String> getAsCompletionList(String toComplete, Collection<String> listOfPossibilities) {
        return new ArrayList<String>(StringUtils.getAsCompletion(toComplete, listOfPossibilities));
    }

    public static ConcurrentSkipListSet<String> getAsCompletion(String[] arguments, String ... listOfPossibilities) {
        ConcurrentSkipListSet strings = new ConcurrentSkipListSet();
        if (arguments == null) {
            return new ConcurrentSkipListSet<String>(List.of(listOfPossibilities));
        }
        if (arguments.length == 0) {
            return new ConcurrentSkipListSet<String>(List.of(listOfPossibilities));
        }
        return StringUtils.getAsCompletion(arguments[arguments.length - 1], listOfPossibilities);
    }

    public static ConcurrentSkipListSet<String> getAsCompletion(String[] arguments, Collection<String> listOfPossibilities) {
        return StringUtils.getAsCompletion(arguments, listOfPossibilities.toArray(new String[0]));
    }

    public static List<String> getAsCompletionList(String[] arguments, String ... listOfPossibilities) {
        return new ArrayList<String>(StringUtils.getAsCompletion(arguments, listOfPossibilities));
    }

    public static List<String> getAsCompletionList(String[] arguments, Collection<String> listOfPossibilities) {
        return new ArrayList<String>(StringUtils.getAsCompletion(arguments, listOfPossibilities));
    }

    public static List<String> stringToList(String string, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null) {
            return list;
        }
        if (string.isEmpty()) {
            return list;
        }
        String[] split = string.split(separator);
        list.addAll(Arrays.asList(split));
        return list;
    }

    public static List<String> stringToList(String string) {
        return StringUtils.stringToList(string, ",");
    }

    public static String listToString(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String string : list) {
            sb.append(string).append(separator);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString().trim();
    }

    public static String listToString(List<String> list) {
        return StringUtils.listToString(list, ",");
    }
}

