/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.classic.joran.action;

import host.plas.bou.libs.logback.classic.Logger;
import host.plas.bou.libs.logback.classic.LoggerContext;
import host.plas.bou.libs.logback.classic.net.SocketAppender;
import host.plas.bou.libs.logback.core.joran.action.Action;
import host.plas.bou.libs.logback.core.joran.spi.ActionException;
import host.plas.bou.libs.logback.core.joran.spi.SaxEventInterpretationContext;
import org.xml.sax.Attributes;

public class ConsolePluginAction
extends Action {
    private static final String PORT_ATTR = "port";
    private static final Integer DEFAULT_PORT = 4321;

    @Override
    public void begin(SaxEventInterpretationContext ec, String name, Attributes attributes) throws ActionException {
        String portStr = attributes.getValue(PORT_ATTR);
        Integer port = null;
        if (portStr == null) {
            port = DEFAULT_PORT;
        } else {
            try {
                port = Integer.valueOf(portStr);
            }
            catch (NumberFormatException ex) {
                this.addError("Port " + portStr + " in ConsolePlugin config is not a correct number");
                this.addError("Abandoning configuration of ConsolePlugin.");
                return;
            }
        }
        LoggerContext lc = (LoggerContext)ec.getContext();
        SocketAppender appender = new SocketAppender();
        appender.setContext(lc);
        appender.setIncludeCallerData(true);
        appender.setRemoteHost("localhost");
        appender.setPort(port);
        appender.start();
        Logger root = lc.getLogger("ROOT");
        root.addAppender(appender);
        this.addInfo("Sending LoggingEvents to the plugin using port " + port);
    }

    @Override
    public void end(SaxEventInterpretationContext ec, String name) throws ActionException {
    }
}

