/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.classic.model.processor;

import host.plas.bou.libs.logback.classic.Level;
import host.plas.bou.libs.logback.classic.Logger;
import host.plas.bou.libs.logback.classic.LoggerContext;
import host.plas.bou.libs.logback.classic.model.RootLoggerModel;
import host.plas.bou.libs.logback.core.Context;
import host.plas.bou.libs.logback.core.model.Model;
import host.plas.bou.libs.logback.core.model.processor.ModelHandlerBase;
import host.plas.bou.libs.logback.core.model.processor.ModelHandlerException;
import host.plas.bou.libs.logback.core.model.processor.ModelInterpretationContext;
import host.plas.bou.libs.logback.core.util.OptionHelper;

public class RootLoggerModelHandler
extends ModelHandlerBase {
    Logger root;
    boolean inError = false;

    public RootLoggerModelHandler(Context context) {
        super(context);
    }

    public static RootLoggerModelHandler makeInstance(Context context, ModelInterpretationContext ic) {
        return new RootLoggerModelHandler(context);
    }

    protected Class<RootLoggerModel> getSupportedModelClass() {
        return RootLoggerModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        this.inError = false;
        RootLoggerModel rootLoggerModel = (RootLoggerModel)model;
        LoggerContext loggerContext = (LoggerContext)this.context;
        this.root = loggerContext.getLogger("ROOT");
        String levelStr = mic.subst(rootLoggerModel.getLevel());
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(levelStr)) {
            Level level = Level.toLevel(levelStr);
            this.addInfo("Setting level of ROOT logger to " + String.valueOf(level));
            this.root.setLevel(level);
        }
        mic.pushObject(this.root);
    }

    @Override
    public void postHandle(ModelInterpretationContext mic, Model model) {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.root) {
            this.addWarn("The object [" + String.valueOf(o) + "] on the top the of the stack is not the root logger");
        } else {
            mic.popObject();
        }
    }
}

