/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.core.model.processor;

import host.plas.bou.libs.logback.core.Context;
import host.plas.bou.libs.logback.core.joran.action.ActionUtil;
import host.plas.bou.libs.logback.core.model.InsertFromJNDIModel;
import host.plas.bou.libs.logback.core.model.Model;
import host.plas.bou.libs.logback.core.model.processor.ModelHandlerBase;
import host.plas.bou.libs.logback.core.model.processor.ModelHandlerException;
import host.plas.bou.libs.logback.core.model.processor.ModelInterpretationContext;
import host.plas.bou.libs.logback.core.model.util.PropertyModelHandlerHelper;
import host.plas.bou.libs.logback.core.util.JNDIUtil;
import host.plas.bou.libs.logback.core.util.OptionHelper;
import javax.naming.NamingException;

public class InsertFromJNDIModelHandler
extends ModelHandlerBase {
    public InsertFromJNDIModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new InsertFromJNDIModelHandler(context);
    }

    protected Class<InsertFromJNDIModel> getSupportedModelClass() {
        return InsertFromJNDIModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        int errorCount = 0;
        InsertFromJNDIModel ifjm = (InsertFromJNDIModel)model;
        String envEntryName = mic.subst(ifjm.getEnvEntryName());
        String asKey = mic.subst(ifjm.getAs());
        String scopeStr = mic.subst(ifjm.getScopeStr());
        ActionUtil.Scope scope = ActionUtil.stringToScope(scopeStr);
        if (OptionHelper.isNullOrEmptyOrAllSpaces(envEntryName)) {
            this.addError("[env-entry-name] missing");
            ++errorCount;
        }
        if (OptionHelper.isNullOrEmptyOrAllSpaces(asKey)) {
            this.addError("[as] missing");
            ++errorCount;
        }
        if (errorCount != 0) {
            return;
        }
        try {
            javax.naming.Context ctx = JNDIUtil.getInitialContext();
            String envEntryValue = JNDIUtil.lookupString(ctx, envEntryName);
            if (OptionHelper.isNullOrEmptyOrAllSpaces(envEntryValue)) {
                this.addError("[" + envEntryName + "] has null or empty value");
            } else {
                this.addInfo("Setting variable [" + asKey + "] to [" + envEntryValue + "] in [" + String.valueOf((Object)scope) + "] scope");
                PropertyModelHandlerHelper.setProperty(mic, asKey, envEntryValue, scope);
            }
        }
        catch (NamingException e) {
            this.addError("Failed to lookup JNDI env-entry [" + envEntryName + "]");
        }
    }
}

