/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.core.util;

import host.plas.bou.libs.logback.core.Context;
import host.plas.bou.libs.logback.core.spi.ContextAwareBase;

public class InterruptUtil
extends ContextAwareBase {
    final boolean previouslyInterrupted;

    public InterruptUtil(Context context) {
        this.setContext(context);
        this.previouslyInterrupted = Thread.currentThread().isInterrupted();
    }

    public void maskInterruptFlag() {
        if (this.previouslyInterrupted) {
            Thread.interrupted();
        }
    }

    public void unmaskInterruptFlag() {
        if (this.previouslyInterrupted) {
            try {
                Thread.currentThread().interrupt();
            }
            catch (SecurityException se) {
                this.addError("Failed to interrupt current thread", se);
            }
        }
    }
}

