/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import java.time.Duration;
import java.time.Instant;

public class HGetExArgs
implements CompositeArgument {
    private Long ex;
    private Long exAt;
    private Long px;
    private Long pxAt;
    private boolean persist = false;

    public HGetExArgs ex(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.ex = timeout.getSeconds();
        return this;
    }

    public HGetExArgs exAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        this.exAt = timestamp.getEpochSecond();
        return this;
    }

    public HGetExArgs px(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.px = timeout.toMillis();
        return this;
    }

    public HGetExArgs pxAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        this.pxAt = timestamp.toEpochMilli();
        return this;
    }

    public HGetExArgs persist() {
        this.persist = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.ex != null) {
            args.add("EX").add(this.ex);
        }
        if (this.exAt != null) {
            args.add("EXAT").add(this.exAt);
        }
        if (this.px != null) {
            args.add("PX").add(this.px);
        }
        if (this.pxAt != null) {
            args.add("PXAT").add(this.pxAt);
        }
        if (this.persist) {
            args.add(CommandType.PERSIST);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static HGetExArgs ex(Duration timeout) {
            return new HGetExArgs().ex(timeout);
        }

        public static HGetExArgs exAt(Instant timestamp) {
            return new HGetExArgs().exAt(timestamp);
        }

        public static HGetExArgs px(Duration timeout) {
            return new HGetExArgs().px(timeout);
        }

        public static HGetExArgs pxAt(Instant timestamp) {
            return new HGetExArgs().pxAt(timestamp);
        }

        public static HGetExArgs persist() {
            return new HGetExArgs().persist();
        }
    }
}

