/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisException;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.masterreplica.MasterReplicaConnectionProvider;
import io.lettuce.core.protocol.ConnectionFacade;
import io.lettuce.core.protocol.ConnectionIntent;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.ReadOnlyCommands;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.resource.ClientResources;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

class MasterReplicaChannelWriter
implements RedisChannelWriter {
    private MasterReplicaConnectionProvider<?, ?> masterReplicaConnectionProvider;
    private final ClientResources clientResources;
    private final ClientOptions clientOptions;
    private final ReadOnlyCommands.ReadOnlyPredicate readOnlyCommands;
    private boolean closed = false;
    private boolean inTransaction;

    MasterReplicaChannelWriter(MasterReplicaConnectionProvider<?, ?> masterReplicaConnectionProvider, ClientResources clientResources, ClientOptions clientOptions) {
        this.masterReplicaConnectionProvider = masterReplicaConnectionProvider;
        this.clientResources = clientResources;
        this.clientOptions = clientOptions;
        this.readOnlyCommands = clientOptions.getReadOnlyCommands();
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        LettuceAssert.notNull(command, "Command must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        if (MasterReplicaChannelWriter.isStartTransaction(command.getType())) {
            this.inTransaction = true;
        }
        ConnectionIntent connectionIntent = this.inTransaction ? ConnectionIntent.WRITE : (this.readOnlyCommands.isReadOnly(command) ? ConnectionIntent.READ : ConnectionIntent.WRITE);
        CompletableFuture<StatefulRedisConnection<?, ?>> future = this.masterReplicaConnectionProvider.getConnectionAsync(connectionIntent);
        if (this.isEndTransaction(command.getType())) {
            this.inTransaction = false;
        }
        if (MasterReplicaChannelWriter.isSuccessfullyCompleted(future)) {
            MasterReplicaChannelWriter.writeCommand(command, future.join(), null);
        } else {
            future.whenComplete((c, t2) -> MasterReplicaChannelWriter.writeCommand(command, c, t2));
        }
        return command;
    }

    private static <K, V> void writeCommand(RedisCommand<K, V, ?> command, StatefulRedisConnection<K, V> connection, Throwable throwable) {
        if (throwable != null) {
            command.completeExceptionally(throwable);
            return;
        }
        try {
            connection.dispatch(command);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> commands) {
        LettuceAssert.notNull(commands, "Commands must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        for (RedisCommand<K, V, ?> command : commands) {
            if (!MasterReplicaChannelWriter.isStartTransaction(command.getType())) continue;
            this.inTransaction = true;
            break;
        }
        ConnectionIntent connectionIntent = this.inTransaction ? ConnectionIntent.WRITE : this.getIntent(commands);
        CompletableFuture<StatefulRedisConnection<?, ?>> future = this.masterReplicaConnectionProvider.getConnectionAsync(connectionIntent);
        for (RedisCommand<K, V, ?> command : commands) {
            if (!this.isEndTransaction(command.getType())) continue;
            this.inTransaction = false;
            break;
        }
        if (MasterReplicaChannelWriter.isSuccessfullyCompleted(future)) {
            MasterReplicaChannelWriter.writeCommands(commands, future.join(), null);
        } else {
            future.whenComplete((c, t2) -> MasterReplicaChannelWriter.writeCommands(commands, c, t2));
        }
        return commands;
    }

    private static <K, V> void writeCommands(Collection<? extends RedisCommand<K, V, ?>> commands, StatefulRedisConnection<K, V> connection, Throwable throwable) {
        if (throwable != null) {
            commands.forEach(c -> c.completeExceptionally(throwable));
            return;
        }
        try {
            connection.dispatch(commands);
        }
        catch (Exception e) {
            commands.forEach(c -> c.completeExceptionally(e));
        }
    }

    ConnectionIntent getIntent(Collection<? extends RedisCommand<?, ?, ?>> commands) {
        if (commands.isEmpty()) {
            return ConnectionIntent.WRITE;
        }
        for (RedisCommand<?, ?, ?> command : commands) {
            if (this.readOnlyCommands.isReadOnly(command)) continue;
            return ConnectionIntent.WRITE;
        }
        return ConnectionIntent.READ;
    }

    @Override
    public void close() {
        this.closeAsync().join();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.closed) {
            return CompletableFuture.completedFuture(null);
        }
        this.closed = true;
        CompletableFuture<Void> future = null;
        if (this.masterReplicaConnectionProvider != null) {
            future = this.masterReplicaConnectionProvider.closeAsync();
            this.masterReplicaConnectionProvider = null;
        }
        if (future == null) {
            future = CompletableFuture.completedFuture(null);
        }
        return future;
    }

    MasterReplicaConnectionProvider<?, ?> getUpstreamReplicaConnectionProvider() {
        return this.masterReplicaConnectionProvider;
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connection) {
    }

    @Override
    public ClientResources getClientResources() {
        return this.clientResources;
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.masterReplicaConnectionProvider.setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.masterReplicaConnectionProvider.flushCommands();
    }

    @Override
    public void reset() {
        this.masterReplicaConnectionProvider.reset();
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.masterReplicaConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.masterReplicaConnectionProvider.getReadFrom();
    }

    private static boolean isSuccessfullyCompleted(CompletableFuture<?> connectFuture) {
        return connectFuture.isDone() && !connectFuture.isCompletedExceptionally();
    }

    private static boolean isStartTransaction(ProtocolKeyword command) {
        return command.toString().equals("MULTI");
    }

    private boolean isEndTransaction(ProtocolKeyword command) {
        return command.toString().equals("EXEC") || command.toString().equals("DISCARD");
    }
}

