/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search;

import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import io.lettuce.core.search.Suggestion;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class SuggestionParser<V>
implements ComplexDataParser<List<Suggestion<V>>> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(SuggestionParser.class);
    private final boolean withScores;
    private final boolean withPayloads;

    public SuggestionParser(boolean withScores, boolean withPayloads) {
        this.withScores = withScores;
        this.withPayloads = withPayloads;
    }

    @Override
    public List<Suggestion<V>> parse(ComplexData data) {
        ArrayList<Suggestion<V>> suggestions = new ArrayList<Suggestion<V>>();
        if (data == null) {
            return suggestions;
        }
        List<Object> elements = data.getDynamicList();
        if (elements == null || elements.isEmpty()) {
            return suggestions;
        }
        int divisor = 1;
        divisor += this.withScores ? 1 : 0;
        if (elements.size() % (divisor += this.withPayloads ? 1 : 0) != 0) {
            LOG.warn("Failed while parsing FT.SUGGET: expected elements to be dividable by {}", (Object)divisor);
            return suggestions;
        }
        int i2 = 0;
        while (i2 < elements.size()) {
            Object value = elements.get(i2++);
            Suggestion<Object> suggestion = new Suggestion<Object>(value);
            if (this.withScores && i2 + 1 <= elements.size()) {
                Double score = this.parseScore(elements.get(i2++));
                suggestion.setScore(score);
            }
            if (this.withPayloads && i2 + 1 <= elements.size()) {
                Object payload = elements.get(i2++);
                suggestion.setPayload(payload);
            }
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    private Double parseScore(Object scoreObj) {
        if (scoreObj == null) {
            return null;
        }
        if (scoreObj instanceof Double) {
            return (Double)scoreObj;
        }
        return 0.0;
    }
}

