/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.search.arguments.FieldArgs;
import java.util.Optional;

public class TagFieldArgs<K>
extends FieldArgs<K> {
    private Optional<String> separator = Optional.empty();
    private boolean caseSensitive;
    private boolean withSuffixTrie;

    public static <K> Builder<K> builder() {
        return new Builder();
    }

    @Override
    public String getFieldType() {
        return "TAG";
    }

    public Optional<String> getSeparator() {
        return this.separator;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isWithSuffixTrie() {
        return this.withSuffixTrie;
    }

    @Override
    protected void buildTypeSpecificArgs(CommandArgs<K, ?> args) {
        this.separator.ifPresent(s2 -> args.add(CommandKeyword.SEPARATOR).add((String)s2));
        if (this.caseSensitive) {
            args.add(CommandKeyword.CASESENSITIVE);
        }
        if (this.withSuffixTrie) {
            args.add(CommandKeyword.WITHSUFFIXTRIE);
        }
    }

    public static class Builder<K>
    extends FieldArgs.Builder<K, TagFieldArgs<K>, Builder<K>> {
        public Builder() {
            super(new TagFieldArgs());
        }

        public Builder<K> separator(String separator) {
            ((TagFieldArgs)this.instance).separator = Optional.of(separator);
            return (Builder)this.self();
        }

        public Builder<K> caseSensitive() {
            ((TagFieldArgs)this.instance).caseSensitive = true;
            return (Builder)this.self();
        }

        public Builder<K> withSuffixTrie() {
            ((TagFieldArgs)this.instance).withSuffixTrie = true;
            return (Builder)this.self();
        }
    }
}

