/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.base.runnables;

import net.streamline.base.StreamlineVelocity;
import net.streamline.platform.savables.UserManager;
import singularity.data.players.CosmicPlayer;
import singularity.scheduler.BaseRunnable;
import singularity.utils.UserUtils;

public class PlayerChecker
extends BaseRunnable {
    public PlayerChecker() {
        super(0L, 1L);
    }

    @Override
    public void run() {
        StreamlineVelocity.getPlayersByUUID().forEach((uuid, player) -> {
            if (UserUtils.isLoaded(player.getUniqueId().toString())) {
                return;
            }
            CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
            if (streamPlayer == null) {
                return;
            }
            streamPlayer.setCurrentIp(UserManager.getInstance().parsePlayerIP(player.getUniqueId().toString()));
            streamPlayer.setCurrentName(player.getUsername());
            player.getCurrentServer().ifPresent(serverConnection -> streamPlayer.setServerName(serverConnection.getServerInfo().getName()));
            streamPlayer.ensureLoaded();
        });
    }
}

