/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.api.util.Favicon;
import gg.drak.thebase.async.AsyncUtils;
import java.awt.image.BufferedImage;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.streamline.api.SLAPI;
import net.streamline.base.StreamlineVelocity;
import net.streamline.platform.Messenger;
import net.streamline.platform.events.ProperEvent;
import net.streamline.platform.savables.UserManager;
import singularity.configs.given.GivenConfigs;
import singularity.configs.given.MainMessagesHandler;
import singularity.configs.given.whitelist.WhitelistConfig;
import singularity.configs.given.whitelist.WhitelistEntry;
import singularity.data.players.CosmicPlayer;
import singularity.data.uuid.UuidManager;
import singularity.events.server.CosmicChatEvent;
import singularity.events.server.KickedFromServerEvent;
import singularity.events.server.LoginCompletedEvent;
import singularity.events.server.LoginReceivedEvent;
import singularity.events.server.LogoutEvent;
import singularity.events.server.ServerStartEvent;
import singularity.events.server.ServerStopEvent;
import singularity.events.server.ping.PingReceivedEvent;
import singularity.messages.builders.ServerNameMessageBuilder;
import singularity.messages.events.ProxyMessageInEvent;
import singularity.messages.proxied.ProxiedMessage;
import singularity.modules.ModuleManager;
import singularity.modules.ModuleUtils;
import singularity.objects.CosmicFavicon;
import singularity.objects.PingedResponse;
import singularity.utils.MessageUtils;
import singularity.utils.UserUtils;

public class PlatformListener {
    public PlatformListener() {
        MessageUtils.logInfo("BaseListener registered!");
    }

    @Subscribe
    public void onPreJoin(PreLoginEvent event) {
        WhitelistEntry entry;
        InboundConnection connection = event.getConnection();
        if (!(connection instanceof Player)) {
            return;
        }
        Player p = (Player)connection;
        String uuid = p.getUniqueId().toString();
        CosmicPlayer streamPlayer = UserUtils.getOrGetPlayer(uuid).orElse(null);
        if (streamPlayer == null) {
            return;
        }
        streamPlayer.waitUntilFullyLoaded();
        streamPlayer.setCurrentName(p.getUsername());
        p.getCurrentServer().ifPresent(serverConnection -> streamPlayer.setServerName(serverConnection.getServerInfo().getName()));
        WhitelistConfig whitelistConfig = GivenConfigs.getWhitelistConfig();
        if (whitelistConfig.isEnabled() && (entry = whitelistConfig.getEntry(streamPlayer.getUuid())) == null) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Messenger.getInstance().codedText(MainMessagesHandler.MESSAGES.INVALID.WHITELIST_NOT.get())));
            return;
        }
        LoginReceivedEvent loginReceivedEvent = new LoginReceivedEvent(streamPlayer);
        ModuleUtils.fireEvent(loginReceivedEvent);
        if (loginReceivedEvent.getResult().isCancelled()) {
            if (!loginReceivedEvent.getResult().validate()) {
                return;
            }
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Messenger.getInstance().codedText(loginReceivedEvent.getResult().getDisconnectMessage())));
        }
    }

    @Subscribe
    public void onJoin(PostLoginEvent event) {
        Player player = event.getPlayer();
        UuidManager.cachePlayer(player.getUniqueId().toString(), player.getUsername(), UserManager.getInstance().parsePlayerIP(player.getUniqueId().toString()));
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getUniqueId().toString() + " (" + player.getUsername() + ")");
            return;
        }
        streamPlayer.setCurrentIp(UserManager.getInstance().parsePlayerIP(player.getUniqueId().toString()));
        streamPlayer.setCurrentName(player.getUsername());
        player.getCurrentServer().ifPresent(serverConnection -> {
            String serverName = serverConnection.getServerInfo().getName();
            streamPlayer.setServerName(serverName);
            if (GivenConfigs.getServerConfig().isAutoCorrect()) {
                AsyncUtils.runAsync(() -> ServerNameMessageBuilder.build(streamPlayer, serverName).send(), 20L);
            }
        });
        LoginCompletedEvent loginCompletedEvent = new LoginCompletedEvent(streamPlayer);
        ModuleUtils.fireEvent(loginCompletedEvent);
    }

    @Subscribe
    public void onLeave(DisconnectEvent event) {
        Player player = event.getPlayer();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getUniqueId().toString() + " (" + player.getUsername() + ")");
            return;
        }
        LogoutEvent logoutEvent = new LogoutEvent(streamPlayer);
        ModuleUtils.fireEvent(logoutEvent);
        streamPlayer.save();
        UserUtils.unloadSender(streamPlayer);
    }

    @Subscribe
    public void onServerSwitch(ServerConnectedEvent event) {
        Player player = event.getPlayer();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getUniqueId().toString() + " (" + player.getUsername() + ")");
            return;
        }
        String serverName = event.getServer().getServerInfo().getName();
        streamPlayer.setServerName(serverName);
        if (GivenConfigs.getServerConfig().isAutoCorrect()) {
            AsyncUtils.runAsync(() -> ServerNameMessageBuilder.build(streamPlayer, serverName).send(), 20L);
        }
    }

    @Subscribe
    public void onChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getUniqueId().toString() + " (" + player.getUsername() + ")");
            return;
        }
        CosmicChatEvent chatEvent = new CosmicChatEvent(streamPlayer, event.getMessage());
        ModuleManager.fireEvent(chatEvent);
        if (chatEvent.isCanceled()) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
            return;
        }
        event.setResult(PlayerChatEvent.ChatResult.message((String)chatEvent.getMessage()));
    }

    @Subscribe
    public void onProperEvent(ProperEvent event) {
        ModuleManager.fireEvent(event.getCosmicEvent());
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        String tag = event.getIdentifier().getId();
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getTarget();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getUniqueId().toString() + " (" + player.getUsername() + ")");
            return;
        }
        try {
            ProxiedMessage messageIn = new ProxiedMessage(streamPlayer, false, event.getData(), tag);
            ProxyMessageInEvent e = (ProxyMessageInEvent)new ProxyMessageInEvent(messageIn).fire();
            if (e.isCancelled()) {
                return;
            }
            SLAPI.getInstance().getProxyMessenger().receiveMessage(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Subscribe
    public void onStart(ProxyInitializeEvent event) {
        ServerStartEvent e = (ServerStartEvent)new ServerStartEvent().fire();
        if (e.isCancelled()) {
            return;
        }
        if (!e.isSendable()) {
            return;
        }
        SLAPI.sendConsoleMessage(e.getMessage());
    }

    @Subscribe
    public void onStop(ProxyShutdownEvent event) {
        ServerStopEvent e = (ServerStopEvent)new ServerStopEvent().fire();
        if (e.isCancelled()) {
            return;
        }
        if (!e.isSendable()) {
            return;
        }
        SLAPI.sendConsoleMessage(e.getMessage());
    }

    @Subscribe
    public void onPing(ProxyPingEvent event) {
        PingedResponse response;
        PingedResponse.Players players;
        String hostName;
        ServerPing ping2 = event.getPing();
        try {
            hostName = ((InetSocketAddress)event.getConnection().getVirtualHost().get()).getHostString();
        }
        catch (Throwable e) {
            hostName = "";
        }
        PingedResponse.Protocol protocol = new PingedResponse.Protocol(ModuleUtils.replacePlaceholders(ping2.getVersion().getName()), ping2.getVersion().getProtocol());
        ArrayList<PingedResponse.PlayerInfo> infos = new ArrayList<PingedResponse.PlayerInfo>();
        if (ping2.getPlayers().isPresent()) {
            for (ServerPing.SamplePlayer info2 : ((ServerPing.Players)ping2.getPlayers().get()).getSample()) {
                infos.add(new PingedResponse.PlayerInfo(info2.getName(), info2.getId()));
            }
            players = new PingedResponse.Players(((ServerPing.Players)ping2.getPlayers().get()).getMax(), ((ServerPing.Players)ping2.getPlayers().get()).getOnline(), infos.toArray(new PingedResponse.PlayerInfo[0]));
        } else {
            players = new PingedResponse.Players(0, 0, new PingedResponse.PlayerInfo[0]);
        }
        try {
            response = ping2.getFavicon().isEmpty() ? new PingedResponse(protocol, players, Messenger.getInstance().asString(ping2.getDescriptionComponent())) : new PingedResponse(protocol, players, Messenger.getInstance().asString(ping2.getDescriptionComponent()), ((Favicon)ping2.getFavicon().get()).getBase64Url());
        }
        catch (Throwable e) {
            MessageUtils.logWarning("Failed to get favicon from ping: " + e.getMessage());
            MessageUtils.logWarning(e.getStackTrace());
            return;
        }
        PingReceivedEvent pingReceivedEvent = (PingReceivedEvent)new PingReceivedEvent(response, hostName).fire();
        if (pingReceivedEvent.isCancelled()) {
            return;
        }
        ServerPing.Builder builder = ping2.asBuilder();
        if (pingReceivedEvent.getResponse().getVersion().getProtocol() != -1) {
            ServerPing.Version protocolServer = new ServerPing.Version(pingReceivedEvent.getResponse().getVersion().getProtocol(), pingReceivedEvent.getResponse().getVersion().getName());
            builder.version(protocolServer);
        }
        ServerPing.SamplePlayer[] infosServer = new ServerPing.SamplePlayer[pingReceivedEvent.getResponse().getPlayers().getSample().length];
        for (int i2 = 0; i2 < pingReceivedEvent.getResponse().getPlayers().getSample().length; ++i2) {
            PingedResponse.PlayerInfo info3 = pingReceivedEvent.getResponse().getPlayers().getSample()[i2];
            infosServer[i2] = new ServerPing.SamplePlayer(MessageUtils.replaceAmpersand(ModuleUtils.replacePlaceholders(info3.getName())), info3.getUniqueId());
        }
        builder.samplePlayers(infosServer);
        builder.onlinePlayers(pingReceivedEvent.getResponse().getPlayers().getOnline());
        builder.maximumPlayers(pingReceivedEvent.getResponse().getPlayers().getMax());
        builder.description(Messenger.getInstance().codedText(ModuleUtils.replacePlaceholders(pingReceivedEvent.getResponse().getDescription())));
        try {
            CosmicFavicon favicon = pingReceivedEvent.getResponse().getFavicon();
            if (favicon != null) {
                Favicon fav = Favicon.create((BufferedImage)favicon.getImage());
                builder.favicon(fav);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.setPing(builder.build());
    }

    @Subscribe
    public void onServerKick(com.velocitypowered.api.event.player.KickedFromServerEvent event) {
        Player player = event.getPlayer();
        RegisteredServer from = event.getServer();
        String kickedReason = event.getServerKickReason().isPresent() ? Messenger.getInstance().asString((Component)event.getServerKickReason().get()) : "none";
        String fromName = from == null ? "none" : from.getServerInfo().getName();
        String toName = player.getCurrentServer().isPresent() ? ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName() : "none";
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getUniqueId().toString() + " (" + player.getUsername() + ")");
            return;
        }
        KickedFromServerEvent kickedFromServerEvent = (KickedFromServerEvent)new KickedFromServerEvent(streamPlayer, fromName, kickedReason, toName).fire();
        if (kickedFromServerEvent.isCancelled()) {
            if (from != null) {
                event.setResult(KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)from));
            }
            return;
        }
        if (kickedFromServerEvent.getToServer() != null && !kickedFromServerEvent.getToServer().equalsIgnoreCase("none")) {
            Optional serverInfo = StreamlineVelocity.getInstance().getProxy().getServer(kickedFromServerEvent.getToServer());
            serverInfo.ifPresent(registeredServer -> event.setResult(KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)registeredServer)));
        }
    }
}

