/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

final class LifecycleMethodUtils {
    private LifecycleMethodUtils() {
    }

    static List<Method> findBeforeAllMethods(Class<?> testClass, boolean requireStatic) {
        return LifecycleMethodUtils.findMethodsAndAssertStaticAndNonPrivate(testClass, requireStatic, BeforeAll.class, ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
    }

    static List<Method> findAfterAllMethods(Class<?> testClass, boolean requireStatic) {
        return LifecycleMethodUtils.findMethodsAndAssertStaticAndNonPrivate(testClass, requireStatic, AfterAll.class, ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
    }

    static List<Method> findBeforeEachMethods(Class<?> testClass) {
        return LifecycleMethodUtils.findMethodsAndAssertNonStaticAndNonPrivate(testClass, BeforeEach.class, ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
    }

    static List<Method> findAfterEachMethods(Class<?> testClass) {
        return LifecycleMethodUtils.findMethodsAndAssertNonStaticAndNonPrivate(testClass, AfterEach.class, ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
    }

    private static List<Method> findMethodsAndAssertStaticAndNonPrivate(Class<?> testClass, boolean requireStatic, Class<? extends Annotation> annotationType, ReflectionUtils.HierarchyTraversalMode traversalMode) {
        List<Method> methods = LifecycleMethodUtils.findMethodsAndCheckVoidReturnType(testClass, annotationType, traversalMode);
        if (requireStatic) {
            methods.forEach(method -> LifecycleMethodUtils.assertStatic(annotationType, method));
        }
        return methods;
    }

    private static List<Method> findMethodsAndAssertNonStaticAndNonPrivate(Class<?> testClass, Class<? extends Annotation> annotationType, ReflectionUtils.HierarchyTraversalMode traversalMode) {
        List<Method> methods = LifecycleMethodUtils.findMethodsAndCheckVoidReturnType(testClass, annotationType, traversalMode);
        methods.forEach(method -> LifecycleMethodUtils.assertNonStatic(annotationType, method));
        return methods;
    }

    private static List<Method> findMethodsAndCheckVoidReturnType(Class<?> testClass, Class<? extends Annotation> annotationType, ReflectionUtils.HierarchyTraversalMode traversalMode) {
        List<Method> methods = AnnotationUtils.findAnnotatedMethods(testClass, annotationType, traversalMode);
        methods.forEach(method -> LifecycleMethodUtils.assertVoid(annotationType, method));
        return methods;
    }

    private static void assertStatic(Class<? extends Annotation> annotationType, Method method) {
        if (ReflectionUtils.isNotStatic(method)) {
            throw new JUnitException(String.format("@%s method '%s' must be static unless the test class is annotated with @TestInstance(Lifecycle.PER_CLASS).", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertNonStatic(Class<? extends Annotation> annotationType, Method method) {
        if (ReflectionUtils.isStatic(method)) {
            throw new JUnitException(String.format("@%s method '%s' must not be static.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertVoid(Class<? extends Annotation> annotationType, Method method) {
        if (!ReflectionUtils.returnsVoid(method)) {
            throw new JUnitException(String.format("@%s method '%s' must not return a value.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }
}

