/*
 * Decompiled with CFR 0.152.
 */
package singularity.configs.given;

import gg.drak.thebase.storage.resources.flat.simple.SimpleConfiguration;
import singularity.Singularity;
import singularity.database.servers.SavedServer;
import singularity.utils.UuidUtils;

public class ServerConfigHandler
extends SimpleConfiguration {
    public ServerConfigHandler() {
        super("server-config.yml", Singularity.getInstance().getDataFolder(), true);
    }

    @Override
    public void init() {
        this.getUuid();
        this.getName();
        this.isAutoCorrect();
    }

    public String getName() {
        this.reloadResource();
        return this.getOrSetDefault("server.name", this.getUuid());
    }

    public String getUuid() {
        this.reloadResource();
        String uuid = this.getOrSetDefault("server.uuid", UuidUtils.randomStringUuid());
        if (!this.isProperUuid(uuid)) {
            uuid = this.getProperUuid(uuid);
            this.write("server.uuid", uuid);
        }
        return uuid;
    }

    public boolean isProperUuid(String uuid) {
        return !uuid.equals("00000000-0000-0000-0000-000000000000") && !uuid.isBlank() && UuidUtils.isUuid(uuid);
    }

    public String getProperUuid(String uuid) {
        if (!this.isProperUuid(uuid)) {
            uuid = UuidUtils.randomStringUuid();
        }
        return uuid;
    }

    public SavedServer getServer() {
        return new SavedServer(this.getUuid(), this.getName(), Singularity.getInstance().getPlatform().getServerType());
    }

    public void writeName(String name) {
        this.write("server.name", name);
    }

    public void writeUuid(String uuid) {
        if (!this.isProperUuid(uuid)) {
            uuid = this.getProperUuid(uuid);
        }
        this.write("server.uuid", uuid);
    }

    public void writeServer(SavedServer server) {
        this.writeName(server.getName());
        this.writeUuid(server.getUuid());
    }

    public boolean isAutoCorrect() {
        this.reloadResource();
        return this.getOrSetDefault("server.auto-correct", true);
    }
}

