/*
 * Decompiled with CFR 0.152.
 */
package singularity.configs.given.punishments;

import java.util.Date;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import singularity.configs.given.punishments.PunishmentType;

public class CosmicPunishment
implements Comparable<CosmicPunishment> {
    private String idHash;
    private String punishedUUID;
    private String punisherUUID;
    private String reason;
    private PunishmentType type;
    private Date timeToUnpunish;

    public CosmicPunishment(String punishedUUID, String punisherUUID, String reason, PunishmentType type, Date timeToUnpunish) {
        String uuid = UUID.randomUUID().toString();
        this.idHash = uuid.substring(0, uuid.indexOf("-")).toUpperCase();
        this.punishedUUID = punishedUUID;
        this.punisherUUID = punisherUUID;
        this.reason = reason;
        this.type = type;
        this.timeToUnpunish = timeToUnpunish;
    }

    @Override
    public int compareTo(@NotNull CosmicPunishment o) {
        return this.idHash.compareTo(o.idHash);
    }

    public void setIdHash(String idHash) {
        this.idHash = idHash;
    }

    public void setPunishedUUID(String punishedUUID) {
        this.punishedUUID = punishedUUID;
    }

    public void setPunisherUUID(String punisherUUID) {
        this.punisherUUID = punisherUUID;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setType(PunishmentType type) {
        this.type = type;
    }

    public void setTimeToUnpunish(Date timeToUnpunish) {
        this.timeToUnpunish = timeToUnpunish;
    }

    public String getIdHash() {
        return this.idHash;
    }

    public String getPunishedUUID() {
        return this.punishedUUID;
    }

    public String getPunisherUUID() {
        return this.punisherUUID;
    }

    public String getReason() {
        return this.reason;
    }

    public PunishmentType getType() {
        return this.type;
    }

    public Date getTimeToUnpunish() {
        return this.timeToUnpunish;
    }
}

