/*
 * Decompiled with CFR 0.152.
 */
package singularity.holders;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListMap;
import singularity.holders.CosmicHolder;
import singularity.modules.ModuleUtils;
import singularity.scheduler.BaseRunnable;
import singularity.utils.MessageUtils;

public abstract class CosmicDependencyHolder<T>
implements CosmicHolder {
    private ConcurrentSkipListMap<Integer, String> keysToTry;
    private T api;
    private String identifier;

    public CosmicDependencyHolder(String identifier, String ... keysToTry) {
        this.identifier = identifier;
        this.keysToTry = new ConcurrentSkipListMap();
        for (String key : keysToTry) {
            this.keysToTry.put(this.keysToTry.size(), key);
        }
    }

    public boolean isPresent() {
        for (String key : this.keysToTry.values()) {
            if (!CosmicDependencyHolder.isPresentCertain(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPresentCertain(String toTry) {
        return ModuleUtils.serverHasPlugin(toTry);
    }

    public void tryLoad(Callable<Void> callable) {
        try {
            callable.call();
        }
        catch (Exception e) {
            MessageUtils.logWarning("Could not load '" + this.getIdentifier() + "'... Retrying in " + LoaderRunnable.getRetryDelay() + " ticks...");
            new LoaderRunnable(0, callable);
        }
    }

    public void setKeysToTry(ConcurrentSkipListMap<Integer, String> keysToTry) {
        this.keysToTry = keysToTry;
    }

    public void setApi(T api) {
        this.api = api;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public ConcurrentSkipListMap<Integer, String> getKeysToTry() {
        return this.keysToTry;
    }

    public T getApi() {
        return this.api;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static class LoaderRunnable
    extends BaseRunnable {
        private static final long retryDelay = 60L;
        private static final long retryPeriod = 1L;
        private static final int retryMax = 3;
        private final int timesTried;
        private final Callable<Void> toRun;

        public LoaderRunnable(int timesTried, Callable<Void> toRun) {
            super(LoaderRunnable.getRetryDelay(), LoaderRunnable.getRetryPeriod());
            this.timesTried = timesTried;
            this.toRun = toRun;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.getToRun().call();
                }
                catch (Exception e) {
                    if (this.getTimesTried() >= LoaderRunnable.getRetryMax()) break block2;
                    new LoaderRunnable(this.getTimesTried() + 1, this.getToRun());
                }
            }
            this.cancel();
        }

        public static long getRetryDelay() {
            return 60L;
        }

        public static long getRetryPeriod() {
            return 1L;
        }

        public static int getRetryMax() {
            return 3;
        }

        public int getTimesTried() {
            return this.timesTried;
        }

        public Callable<Void> getToRun() {
            return this.toRun;
        }
    }
}

