/*
 * Decompiled with CFR 0.152.
 */
package singularity.messages.answered;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import singularity.messages.events.AnsweredMessageEvent;
import singularity.messages.proxied.ProxiedMessage;
import singularity.messages.proxied.ProxiedMessageManager;
import singularity.scheduler.BaseRunnable;

public class ReturnableMessage
implements Comparable<ReturnableMessage> {
    private static final String key = "{{key}}";
    private static final int timeoutTicks = 60;
    private static final int testingTicks = 1;
    private String answerKey;
    private ProxiedMessage payload;
    private boolean fired = false;
    private boolean called = false;
    private TimeoutTimer timeoutTimer;
    private ConcurrentSkipListMap<Integer, Consumer<ProxiedMessage>> registeredEvents = new ConcurrentSkipListMap();
    private Optional<ProxiedMessage> answer = Optional.empty();

    public ReturnableMessage(ProxiedMessage payload, boolean send) {
        this.payload = payload;
        this.answerKey = UUID.randomUUID().toString();
        this.getPayload().write(ReturnableMessage.getKey(), this.getAnswerKey());
        this.setTimeoutTimer(new TimeoutTimer(this));
        if (send) {
            this.send();
        }
    }

    public ReturnableMessage(ProxiedMessage payload) {
        this(payload, true);
    }

    public void send() {
        ProxiedMessageManager.sendReturnable(this);
    }

    public boolean tryAnswer(ProxiedMessage answer) {
        if (answer.getString(ReturnableMessage.getKey()).equals(this.getAnswerKey())) {
            this.acceptAnswer(answer);
            return true;
        }
        return false;
    }

    public boolean isAnswered() {
        return this.answer.isPresent();
    }

    public void acceptAnswer(ProxiedMessage message) {
        this.answer = Optional.of(message);
        AnsweredMessageEvent event = (AnsweredMessageEvent)new AnsweredMessageEvent(this, message).fire();
        if (event.isCancelled()) {
            return;
        }
        this.fire(message);
        this.setFired(true);
        this.callEvents(message);
        this.setCalled(true);
        this.killNow();
    }

    public void fire(ProxiedMessage message) {
    }

    public boolean kill() {
        return ProxiedMessageManager.killReturnable(this);
    }

    public void killNow() {
        this.getTimeoutTimer().cancel();
        ProxiedMessageManager.unloadReturnableMessage(this);
    }

    public void registerEventCall(Consumer<ProxiedMessage> consumer) {
        this.getRegisteredEvents().put(this.getRegisteredEvents().size() + 1, consumer);
    }

    public void callEvents(ProxiedMessage accepted) {
        this.getRegisteredEvents().forEach((integer, consumer) -> {
            try {
                consumer.accept(accepted);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public int compareTo(@NotNull ReturnableMessage o) {
        return Long.compare(this.getPayload().getGottenAt().getTime(), o.getPayload().getGottenAt().getTime());
    }

    public void setAnswerKey(String answerKey) {
        this.answerKey = answerKey;
    }

    public void setPayload(ProxiedMessage payload) {
        this.payload = payload;
    }

    public void setFired(boolean fired) {
        this.fired = fired;
    }

    public void setCalled(boolean called) {
        this.called = called;
    }

    public void setTimeoutTimer(TimeoutTimer timeoutTimer) {
        this.timeoutTimer = timeoutTimer;
    }

    public void setRegisteredEvents(ConcurrentSkipListMap<Integer, Consumer<ProxiedMessage>> registeredEvents) {
        this.registeredEvents = registeredEvents;
    }

    public void setAnswer(Optional<ProxiedMessage> answer) {
        this.answer = answer;
    }

    public static String getKey() {
        return key;
    }

    public static int getTimeoutTicks() {
        return 60;
    }

    public static int getTestingTicks() {
        return 1;
    }

    public String getAnswerKey() {
        return this.answerKey;
    }

    public ProxiedMessage getPayload() {
        return this.payload;
    }

    public boolean isFired() {
        return this.fired;
    }

    public boolean isCalled() {
        return this.called;
    }

    public TimeoutTimer getTimeoutTimer() {
        return this.timeoutTimer;
    }

    public ConcurrentSkipListMap<Integer, Consumer<ProxiedMessage>> getRegisteredEvents() {
        return this.registeredEvents;
    }

    public Optional<ProxiedMessage> getAnswer() {
        return this.answer;
    }

    public static class TimeoutTimer
    extends BaseRunnable {
        private ReturnableMessage parent;

        public TimeoutTimer(ReturnableMessage returnableMessage) {
            super(ReturnableMessage.getTestingTicks(), ReturnableMessage.getTestingTicks());
            this.setParent(returnableMessage);
        }

        @Override
        public void run() {
            if (this.getParent().kill()) {
                this.cancel();
            }
        }

        public void setParent(ReturnableMessage parent) {
            this.parent = parent;
        }

        public ReturnableMessage getParent() {
            return this.parent;
        }
    }
}

