/*
 * Decompiled with CFR 0.152.
 */
package singularity.modules;

import com.google.common.base.Preconditions;
import gg.drak.thebase.events.BaseEventHandler;
import gg.drak.thebase.events.BaseEventListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.pf4j.JarPluginLoader;
import org.pf4j.JarPluginManager;
import org.pf4j.ManifestPluginDescriptorFinder;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginLoader;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import singularity.Singularity;
import singularity.command.CommandHandler;
import singularity.command.ModuleCommand;
import singularity.events.CosmicEvent;
import singularity.events.modules.ModuleLoadEvent;
import singularity.modules.CosmicModule;
import singularity.modules.ModuleLike;
import singularity.modules.ModuleUtils;
import singularity.utils.MessageUtils;

public class ModuleManager {
    private static ConcurrentSkipListMap<String, ModuleLike> loadedModules = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, ModuleLike> enabledModules = new ConcurrentSkipListMap();
    private static JarPluginManager pluginManager;
    private static final String noModulesMessage = "&a&m&l                                                 %newline%               &c&lStreamline &5&lCore%newline%&eIt appears you do not have any modules installed&7. &eThis%newline%&eplugin was meant to be used with modules&7. &eModules%newline%&eare installable content &b(&7you can create your own&5!&b)%newline%&ethat either expand upon the core plugin or add%newline%&ecompletely new content to your server&b(&es&b)&7.%newline%&eInstall them by placing them in your servers&7'%newline%&7\"&bplugins -> StreamlineCore -> modules&7\" &efolder&7.%newline%&eYou can check them out and download them from our%newline%&c&lModule Public Download Stash&e. Thanks! And enjoy!%newline%&r%newline%&a&m&l                                                 %newline%&r%newline%&fUse the following to download &6Modules &ddirectly &c->%newline%&6Modules &c&lPublic Download Stash&7: &bhttps://storage.drak.gg/share/75RJ__vUBVQrC_PRfuHeTg%newline%&r%newline%&a&m&l                                                 %newline%&r%newline%&6Streamline &b&lWiki&7: &bhttps://wiki.drak.gg/streamline%newline%&6Streamline &9&lDiscord&7: &bhttps://dsc.gg/streamline%newline%&6Drak&7'&6s &c&lSocials &6Page&7: &bhttps://drak.gg/socials%newline%&r%newline%&a&m&l                                                 %newline%&cDisable &ethis message in the &bmain-config.yml%newline%&a&m&l                                                 ";

    public static ConcurrentSkipListMap<String, File> getModuleFiles() {
        ConcurrentSkipListMap<String, File> r = new ConcurrentSkipListMap<String, File>();
        File[] files = Singularity.getModuleFolder().listFiles();
        if (files == null) {
            return r;
        }
        for (File file : files) {
            if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
            r.put(file.getName(), file);
        }
        return r;
    }

    public static List<Path> getModuleFilesAsPaths() {
        ArrayList<Path> r = new ArrayList<Path>();
        ModuleManager.getModuleFiles().forEach((s2, file) -> r.add(file.toPath()));
        return r;
    }

    public static JarPluginManager safePluginManager() {
        JarPluginManager manager = ModuleManager.getPluginManager();
        if (manager != null) {
            return manager;
        }
        manager = new JarPluginManager(new Path[]{Singularity.getModuleFolder().toPath()}){

            @Override
            protected PluginLoader createPluginLoader() {
                return new JarPluginLoader(this);
            }

            @Override
            protected PluginDescriptorFinder createPluginDescriptorFinder() {
                return new ManifestPluginDescriptorFinder();
            }
        };
        ModuleManager.setPluginManager(manager);
        return manager;
    }

    public static void loadModule(@NonNull ModuleLike module) {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        if (ModuleManager.getLoadedModules().containsKey(module.getIdentifier())) {
            if (!ModuleManager.getModule(module.getIdentifier()).isMalleable()) {
                MessageUtils.logWarning("Module '" + module.getIdentifier() + "' by '" + module.getAuthorsStringed() + "' could not be loaded: identical identifiers");
                return;
            }
            ModuleManager.unregisterModule(module);
        }
        ModuleManager.getLoadedModules().put(module.getIdentifier(), module);
        if (module instanceof CosmicModule) {
            ModuleUtils.fireEvent(new ModuleLoadEvent((CosmicModule)module));
        }
    }

    public static void registerExternalModules() {
        if (!ModuleManager.hasNonBaseModules()) {
            MessageUtils.logInfo(ModuleManager.getNoModulesMessage());
            return;
        }
        MessageUtils.logInfo("&rLoading external modules...");
        Date before = new Date();
        int loaded = ModuleManager.loadModulesSafe();
        Date after = new Date();
        long millis = after.getTime() - before.getTime();
        MessageUtils.logInfo("&rLoaded &a" + loaded + " &rexternal modules in &a" + millis + "&6ms&f.");
    }

    public static int loadModulesSafe() {
        AtomicInteger i2 = new AtomicInteger(0);
        File pathFile = ModuleManager.safePluginManager().getPluginsRoot().toFile();
        File[] files = pathFile.listFiles();
        if (files == null) {
            return i2.get();
        }
        Arrays.stream(files).forEach(file -> {
            if (file.getName().endsWith(".jar")) {
                try {
                    ModuleManager.safePluginManager().loadPlugin(file.toPath());
                    i2.getAndIncrement();
                }
                catch (Exception e) {
                    MessageUtils.logSevere("Could not load module '" + file.getName() + "':", e);
                }
            }
        });
        return i2.get();
    }

    public static void registerExternalModule(@NotNull String jarName) {
        if (!((String)jarName).endsWith(".jar")) {
            jarName = (String)jarName + ".jar";
        }
        ModuleManager.safePluginManager().loadPlugin(ModuleManager.safePluginManager().getPluginsRoot().resolve((String)jarName));
        PluginWrapper plugin = ModuleManager.getPluginWrapperByJarName((String)jarName);
        ModuleManager.safePluginManager().startPlugin(plugin.getPluginId());
    }

    public static PluginWrapper getPluginWrapperByJarName(String jarName) {
        AtomicReference r = new AtomicReference();
        ModuleManager.safePluginManager().getPlugins().forEach(plugin -> {
            if (plugin.getPluginPath().endsWith(jarName)) {
                r.set(plugin);
            }
        });
        return (PluginWrapper)r.get();
    }

    public static ConcurrentSkipListSet<String> getExternalModuleIdentifiers() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        File[] files = ModuleManager.safePluginManager().getPluginsRoot().toFile().listFiles();
        if (files == null) {
            return r;
        }
        Arrays.asList(files).forEach(file -> {
            if (file.isDirectory()) {
                return;
            }
            if (!file.getName().endsWith(".jar")) {
                return;
            }
            r.add(file.getName());
        });
        return r;
    }

    public static ConcurrentSkipListSet<String> getLoadedExternalModuleIdentifiers() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        ModuleManager.getExternalModuleIdentifiers().forEach(identifier -> {
            PluginWrapper pluginWrapper = ModuleManager.getPluginWrapperByJarName(identifier);
            if (pluginWrapper == null) {
                return;
            }
            if (pluginWrapper.getPluginState() != PluginState.DISABLED) {
                r.add((String)identifier);
            }
        });
        return r;
    }

    public static ConcurrentSkipListSet<String> getUnloadedExternalModuleIdentifiers() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        ModuleManager.getExternalModuleIdentifiers().forEach(identifier -> {
            if (ModuleManager.getLoadedExternalModuleIdentifiers().contains(identifier)) {
                return;
            }
            r.add((String)identifier);
        });
        return r;
    }

    public static boolean hasNonBaseModules() {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ModuleManager.safePluginManager().getPluginsRoots().forEach(path -> {
            try {
                File[] files = path.toFile().listFiles();
                if (files == null) {
                    return;
                }
                Arrays.stream(files).forEach(file -> {
                    if (file.getName().endsWith(".jar")) {
                        atomicBoolean.set(true);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return atomicBoolean.get();
    }

    public static void registerModule(ModuleLike module) {
        Preconditions.checkNotNull(module, "module parameter cannot be null.");
        ModuleManager.loadModule(module);
        module.logInfo("Registered module!");
    }

    public static void unregisterModule(ModuleLike module) {
        try {
            module.stop();
            ModuleManager.safePluginManager().unloadPlugin(module.getIdentifier());
            BaseEventHandler.unbake(module);
            ModuleManager.getLoadedModules().remove(module.getIdentifier());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ModuleLike getModule(String identifier) {
        return ModuleManager.getLoadedModules().get(identifier);
    }

    public static ConcurrentSkipListSet<ModuleCommand> getCommandsForModule(ModuleLike module) {
        ConcurrentSkipListSet<ModuleCommand> r = new ConcurrentSkipListSet<ModuleCommand>();
        CommandHandler.getLoadedModuleCommands().forEach((s2, moduleCommand) -> {
            if (moduleCommand.getOwningModule().getIdentifier().equals(module.getIdentifier())) {
                r.add((ModuleCommand)moduleCommand);
            }
        });
        return r;
    }

    public static void unloadCommandsForModule(ModuleLike module) {
        ModuleManager.getCommandsForModule(module).forEach(command -> {
            if (command.isLoaded()) {
                command.disable();
            }
        });
    }

    public static void reapplyModule(String id) {
        ModuleLike moduleLike = ModuleManager.getModule(id);
        if (Singularity.getBaseModule() != null) {
            if (moduleLike.equals(Singularity.getBaseModule())) {
                return;
            }
        } else {
            MessageUtils.logWarning("Base module is null!");
        }
        BaseEventHandler.unbake(moduleLike);
        Path path = ModuleManager.safePluginManager().getPlugin(id).getPluginPath();
        try {
            ModuleManager.safePluginManager().stopPlugin(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ModuleManager.safePluginManager().unloadPlugin(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ModuleManager.safePluginManager().loadPlugin(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ModuleManager.safePluginManager().startPlugin(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void restartModules() {
        ModuleManager.getLoadedModules().forEach((s2, moduleLike) -> moduleLike.restart());
    }

    public static void startModules() {
        ModuleManager.safePluginManager().startPlugins();
    }

    public static void stopModules() {
        ModuleManager.safePluginManager().stopPlugins();
    }

    public static void fireEvent(@NotNull CosmicEvent event) {
        BaseEventHandler.fireEvent(event);
    }

    public static <T extends ModuleLike> void unregisterHandlersOf(T module) {
        BaseEventHandler.unbake(module);
    }

    public static <T extends ModuleLike> void registerEvents(@NotNull BaseEventListener listener, @NotNull T module) {
        BaseEventHandler.bake(listener, module);
    }

    public static boolean hasModule(String identifier) {
        return ModuleManager.safePluginManager().getPlugin(identifier) != null;
    }

    public static boolean hasModuleLoaded(String identifier) {
        return ModuleManager.getLoadedModules().containsKey(identifier);
    }

    public static boolean hasModuleEnabled(String identifier) {
        return ModuleManager.getEnabledModules().containsKey(identifier);
    }

    public static boolean hasModuleLoadedAndEnabled(String identifier) {
        return ModuleManager.hasModuleLoaded(identifier) && ModuleManager.hasModuleEnabled(identifier);
    }

    public static void unregisterModule(String s2, ModuleLike ModuleLike2) {
        ModuleManager.unregisterModule(ModuleLike2);
    }

    public static ConcurrentSkipListSet<ModuleLike> getOnlyMalleableModules() {
        ConcurrentSkipListSet<ModuleLike> r = new ConcurrentSkipListSet<ModuleLike>();
        ModuleManager.getLoadedModules().forEach((s2, moduleLike) -> {
            if (moduleLike.isMalleable()) {
                r.add((ModuleLike)moduleLike);
            }
        });
        return r;
    }

    public static ConcurrentSkipListSet<String> getOnlyMalleableModuleIdentifiers() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        ModuleManager.getOnlyMalleableModules().forEach(moduleLike -> r.add(moduleLike.getIdentifier()));
        return r;
    }

    public static ConcurrentSkipListSet<String> getOnlyMalleableEnabledModuleIdentifiers() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        ModuleManager.getOnlyMalleableModules().forEach(moduleLike -> {
            if (moduleLike.isEnabled()) {
                r.add(moduleLike.getIdentifier());
            }
        });
        return r;
    }

    public static ConcurrentSkipListSet<String> getLoadedModuleIdentifiers() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        ModuleManager.getLoadedModules().forEach((s2, module) -> r.add(module.getIdentifier()));
        return r;
    }

    public static ConcurrentSkipListSet<String> getEnabledModuleIdentifiers() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        ModuleManager.getEnabledModules().forEach((s2, module) -> r.add(module.getIdentifier()));
        return r;
    }

    public static ConcurrentSkipListSet<String> getColorizedLoadedModuleIdentifiers() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        ModuleManager.getLoadedModules().forEach((s2, module) -> {
            if (module.isMalleable()) {
                if (module.isEnabled()) {
                    r.add("&a" + module.getIdentifier());
                } else {
                    r.add("&c" + module.getIdentifier());
                }
            } else {
                r.add("&7" + module.getIdentifier());
            }
        });
        return r;
    }

    public static ConcurrentSkipListMap<String, ModuleLike> getLoadedModules() {
        return loadedModules;
    }

    public static void setLoadedModules(ConcurrentSkipListMap<String, ModuleLike> loadedModules) {
        ModuleManager.loadedModules = loadedModules;
    }

    public static ConcurrentSkipListMap<String, ModuleLike> getEnabledModules() {
        return enabledModules;
    }

    public static void setEnabledModules(ConcurrentSkipListMap<String, ModuleLike> enabledModules) {
        ModuleManager.enabledModules = enabledModules;
    }

    public static JarPluginManager getPluginManager() {
        return pluginManager;
    }

    public static void setPluginManager(JarPluginManager pluginManager) {
        ModuleManager.pluginManager = pluginManager;
    }

    public static String getNoModulesMessage() {
        return noModulesMessage;
    }
}

