/*
 * Decompiled with CFR 0.152.
 */
package singularity.redis;

import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.Arrays;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import singularity.redis.OwnRedisClient;
import singularity.redis.RedisMessage;
import singularity.utils.MessageUtils;

public abstract class AbstractRedisListener
implements RedisPubSubListener<String, String> {
    private String identifier;
    private String[] channels;
    private StatefulRedisPubSubConnection<String, String> connection;

    public AbstractRedisListener(String identifier, String ... channels) {
        this.identifier = identifier;
        this.channels = channels;
        this.connect();
    }

    public void connect() {
        this.connection = OwnRedisClient.getClient().connectPubSub();
    }

    public boolean containsChannel(String channel) {
        return Arrays.stream(this.channels).anyMatch(c -> c.equals(channel) || c.equals("~" + channel));
    }

    @Override
    public void message(String channel, String message) {
        if (!this.containsChannel(channel)) {
            return;
        }
        this.onMessage(channel, message);
    }

    public void onMessage(String channel, String message) {
        this.onMessage(new RedisMessage(channel, message));
    }

    @Override
    public void message(String pattern, String channel, String message) {
        if (!this.containsChannel(channel)) {
            return;
        }
        this.onMessage(channel, message);
    }

    @Override
    public void subscribed(String channel, long count) {
    }

    @Override
    public void psubscribed(String pattern, long count) {
    }

    @Override
    public void unsubscribed(String channel, long count) {
    }

    @Override
    public void punsubscribed(String pattern, long count) {
    }

    public void onMessage(RedisMessage redisMessage) {
    }

    public ConcurrentSkipListSet<String> getChannelsSet() {
        return new ConcurrentSkipListSet<String>(Arrays.asList(this.channels));
    }

    public void forEachChannel(Consumer<String> consumer) {
        this.getChannelsSet().forEach(consumer);
    }

    public void register() {
        try {
            if (this.getConnection() == null || !this.isConnected()) {
                this.connect();
            }
            RedisAsyncCommands r = this.getConnection().async();
            r.getStatefulConnection().addListener(this);
            r.subscribe(this.getChannels());
            MessageUtils.logInfo("&cRedisListener &fregistered: &d" + this.getIdentifier());
        }
        catch (Throwable e) {
            MessageUtils.logWarning("&cRedisListener &ferror registering: &d" + this.getIdentifier() + " &7-> &f" + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return this.getConnection().isOpen();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getChannels() {
        return this.channels;
    }

    public StatefulRedisPubSubConnection<String, String> getConnection() {
        return this.connection;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setChannels(String[] channels) {
        this.channels = channels;
    }

    public void setConnection(StatefulRedisPubSubConnection<String, String> connection) {
        this.connection = connection;
    }
}

