/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import io.lettuce.core.vector.QuantizationType;
import io.lettuce.core.vector.VectorMetadata;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VectorMetadataParser
implements ComplexDataParser<VectorMetadata> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(VectorMetadataParser.class);
    public static final VectorMetadataParser INSTANCE = new VectorMetadataParser();
    private static final String ATTRIBUTES_COUNT = "attributes-count";
    private static final String SIZE = "size";
    private static final String MAX_NODES = "hnsw-m";
    private static final String VSET_UID = "vset-uid";
    private static final String QUANT_TYPE = "quant-type";
    private static final String MAX_LEVEL = "max-level";
    private static final String VECTOR_DIM = "vector-dim";
    private static final String MAX_NODE_UID = "hnsw-max-node-uid";
    private static final String PROJECTION_INPUT_DIM = "projection-input-dim";
    private static final String INT8 = "int8";
    private static final String FLOAT32 = "float32";
    private static final String BINARY = "binary";

    private VectorMetadataParser() {
    }

    @Override
    public VectorMetadata parse(ComplexData dynamicData) {
        List<Object> data = this.verifyStructure(dynamicData);
        if (data == null) {
            return null;
        }
        VectorMetadata metadata = new VectorMetadata();
        block22: for (int i = 0; i < data.size() && i + 1 < data.size(); i += 2) {
            String key = data.get(i).toString();
            Object value = data.get(i + 1);
            switch (key) {
                case "attributes-count": {
                    metadata.setAttributesCount(this.parseInteger(value));
                    continue block22;
                }
                case "size": {
                    metadata.setSize(this.parseInteger(value));
                    continue block22;
                }
                case "quant-type": {
                    metadata.setType(this.parseQuantizationType(value.toString()));
                    continue block22;
                }
                case "vector-dim": {
                    metadata.setDimensionality(this.parseInteger(value));
                    continue block22;
                }
                case "max-level": {
                    metadata.setMaxLevel(this.parseInteger(value));
                    continue block22;
                }
                case "hnsw-m": {
                    metadata.setMaxNodes(this.parseInteger(value));
                    continue block22;
                }
                case "hnsw-max-node-uid": {
                    metadata.setMaxNodeUid(this.parseInteger(value));
                    continue block22;
                }
                case "projection-input-dim": {
                    metadata.setProjectionInputDim(this.parseInteger(value));
                    continue block22;
                }
                case "vset-uid": {
                    metadata.setvSetUid(this.parseInteger(value));
                }
            }
        }
        return metadata;
    }

    private List<Object> verifyStructure(ComplexData vinfoOutput) {
        List<Object> data;
        if (vinfoOutput == null) {
            LOG.warn("Failed while parsing VINFO: vinfoOutput must not be null");
            return null;
        }
        try {
            data = vinfoOutput.getDynamicList();
        }
        catch (UnsupportedOperationException e) {
            try {
                Map<Object, Object> map = vinfoOutput.getDynamicMap();
                data = new ArrayList<Object>(map.size() * 2);
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    data.add(entry.getKey());
                    data.add(entry.getValue());
                }
            }
            catch (UnsupportedOperationException ex) {
                LOG.warn("Failed while parsing VINFO: vinfoOutput must be a list or a map", ex);
                return new ArrayList<Object>();
            }
        }
        if (data == null || data.isEmpty()) {
            LOG.warn("Failed while parsing VINFO: data must not be null or empty");
            return new ArrayList<Object>();
        }
        if (data.size() % 2 != 0) {
            LOG.warn("Failed while parsing VINFO: data must contain key-value pairs");
            return new ArrayList<Object>();
        }
        return data;
    }

    private Integer parseInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private QuantizationType parseQuantizationType(String quantTypeStr) {
        switch (quantTypeStr.toLowerCase()) {
            case "int8": {
                return QuantizationType.Q8;
            }
            case "float32": {
                return QuantizationType.NO_QUANTIZATION;
            }
            case "binary": {
                return QuantizationType.BINARY;
            }
        }
        return null;
    }
}

